/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level.sniffer;

import co.elastic.clients.transport.rest5_client.low_level.Node;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.sniffer.Sniffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class SniffOnFailureListener
extends Rest5Client.FailureListener {
    private volatile Sniffer sniffer;
    private final AtomicBoolean set = new AtomicBoolean(false);

    public void setSniffer(Sniffer sniffer) {
        Objects.requireNonNull(sniffer, "sniffer must not be null");
        if (!this.set.compareAndSet(false, true)) {
            throw new IllegalStateException("sniffer can only be set once");
        }
        this.sniffer = sniffer;
    }

    @Override
    public void onFailure(Node node) {
        if (this.sniffer == null) {
            throw new IllegalStateException("sniffer was not set, unable to sniff on failure");
        }
        this.sniffer.sniffOnFailure();
    }
}

