/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.api.util.Assert;
import com.adobe.aem.dermis.exception.DermisException;
import com.google.gson.Gson;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONObject;

public class Binary {
    private String contentType;
    private byte[] bytes;
    private String uri;
    private String name;

    public Binary() {
    }

    @Deprecated
    public Binary(String contentType, byte[] bytes) {
        this.contentType = contentType;
        this.bytes = bytes;
    }

    public Binary(String contentType, byte[] bytes, @Nonnull String name) throws DermisException {
        Assert.assertNotNull((String)name, (String)"AEM-FDM-001-056", null, (int)1);
        this.contentType = contentType;
        this.bytes = bytes;
        this.name = name;
    }

    @Deprecated
    public Binary(String contentType, String uri) {
        this.contentType = contentType;
        this.uri = uri;
    }

    public Binary(String contentType, String uri, @Nonnull String name) throws DermisException {
        Assert.assertNotNull((String)name, (String)"AEM-FDM-001-056", null, (int)1);
        this.contentType = contentType;
        this.uri = uri;
        this.name = name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        String data = null;
        if (StringUtils.isNotBlank((CharSequence)this.uri)) {
            data = this.uri;
        } else if (this.bytes != null) {
            data = "data:" + this.contentType + ";base64," + Base64.encodeBase64String((byte[])this.bytes);
        }
        return data;
    }

    @Deprecated
    public JSONObject toJson() {
        try {
            JSONObject jsonObject = new JSONObject(new Gson().toJson((Object)this));
            if (jsonObject.has("uri")) {
                jsonObject.put("data", jsonObject.get("uri"));
            }
            return jsonObject;
        }
        catch (Exception e) {
            return null;
        }
    }
}

