/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.formset.common;

import com.adobe.aemds.formset.common.FormResource;
import com.adobe.aemds.formset.exception.FormsetException;
import com.adobe.forms.option.LCFormsOptions;
import com.adobe.forms.service.LCFormsService;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileFormResource
extends FormResource {
    private Logger logger = LoggerFactory.getLogger(MobileFormResource.class);
    private String contentRoot;
    private String template;

    public MobileFormResource(Resource resource, int number) {
        super(resource, number);
        String xdpPath = (String)this.resourceProps.get((Object)PROPERTY_NAME_XDP_PATH);
        this.contentRoot = "crx://" + xdpPath.substring(0, xdpPath.lastIndexOf("/"));
        this.template = xdpPath.substring(xdpPath.lastIndexOf("/") + 1);
        this.type = MF_RESOURCE;
    }

    public String getContentRoot() {
        return this.contentRoot;
    }

    public String getTemplateName() {
        return this.template;
    }

    @Override
    public void addKeys(JSONWriter jsonWriter) throws JSONException {
        super.addKeys(jsonWriter);
        jsonWriter.key("contentRoot").value((Object)this.contentRoot).key("template").value((Object)this.template);
    }

    @Override
    public String getDataXML(LCFormsService formService, JSONObject submitData, String prefillXML) throws FormsetException {
        try {
            LCFormsOptions formOptions = new LCFormsOptions();
            formOptions.setContentRoot(this.contentRoot);
            formOptions.setTemplate(this.template);
            formOptions.setRenderType("html");
            formOptions.setUseXFA4J(null);
            formOptions.setFormDom(submitData.getString("xfaDom"));
            if (prefillXML != null) {
                formOptions.setData(prefillXML);
            }
            Map contentMap = formService.exportXFA(formOptions);
            String xfaResult = "";
            if (contentMap.containsKey("mergedformdom")) {
                xfaResult = (String)contentMap.get("mergedformdom");
            }
            return xfaResult;
        }
        catch (Exception e) {
            throw new FormsetException(e);
        }
    }

    @Override
    public String getPrefillJson(LCFormsService formService, String xml) throws FormsetException {
        try {
            if (xml == null || "/".equals(this.getXMLRoot())) {
                return null;
            }
            LCFormsOptions formOptions = new LCFormsOptions();
            formOptions.setContentRoot(this.contentRoot);
            formOptions.setTemplate(this.template);
            formOptions.setRenderType("html");
            formOptions.setUseXFA4J(null);
            formOptions.setData(xml);
            Map contentMap = formService.render(formOptions);
            String xfaResult = null;
            if (contentMap.containsKey("mergedformdom")) {
                xfaResult = (String)contentMap.get("mergedformdom");
            }
            return xfaResult;
        }
        catch (Exception e) {
            this.logger.warn("[FormSet] Unable to get prefillJson for the Form " + this.getFormNumber(), (Throwable)e);
            this.logger.debug("[FormSet] PrefillJson failed for: " + this.getFormNumber() + " with xml " + xml);
            throw new FormsetException(e);
        }
    }
}

