/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.aemds.guide.utils.AuthoringErrorMessages;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideCaptcha
extends GuideField {
    private static final Logger logger = LoggerFactory.getLogger(GuideCaptcha.class);
    private AdaptiveFormConfigurationService configService;
    private String RECAPTCHA_VALIDATION_SERVICE = "recaptcha";
    private String RECAPTCHA_CLOUD_PATH = "rcCloudServicePath";

    public String getAuthoringAltText() {
        return this.externalize("Captcha", "jcr:title");
    }

    @Override
    public String getGuideFieldType() {
        return "guideCaptcha";
    }

    public String getCaptchaService() {
        String captchaService = (String)this.resourceProps.get("captchaService", (Object)"");
        if ("afcaptcha".equals(captchaService)) {
            logger.error(AuthoringErrorMessages.AUTHORING_ERROR_MAP.get("MSG_DEFAULT_CAPTCHA_0001"));
        }
        return captchaService;
    }

    public String getExternalDomain() {
        String overriddenDomain = "";
        if (StringUtils.equals((CharSequence)this.getCaptchaService(), (CharSequence)this.RECAPTCHA_VALIDATION_SERVICE)) {
            overriddenDomain = ((AdaptiveFormConfigurationService)this.getSlingScriptHelper().getService(AdaptiveFormConfigurationService.class)).recaptchaDomain();
        }
        return overriddenDomain;
    }

    public String getLocale() {
        return GuideUtils.getAcceptLang(this.slingRequest);
    }

    public Map<String, Object> getResourceProperties() {
        return this.resourceProps;
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        String cloudServicePath = (String)this.resourceProps.get(this.RECAPTCHA_CLOUD_PATH, String.class);
        if (StringUtils.equals((CharSequence)this.getCaptchaService(), (CharSequence)this.RECAPTCHA_VALIDATION_SERVICE) && StringUtils.isBlank((CharSequence)cloudServicePath)) {
            authoringConfig.put("isRecaptchaConfigMissing", true);
        } else {
            authoringConfig.put("isRecaptchaConfigMissing", false);
        }
        return authoringConfig;
    }
}

