/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.wcm.foundation.Image;
import java.io.IOException;
import java.io.Serializable;
import javax.jcr.RepositoryException;

public class GuideImage
extends GuideField
implements Serializable {
    private Image image;

    public String getImageSrc() throws RepositoryException, IOException {
        this.image = new Image(this.getResource());
        Boolean containsData = this.image.getData() != null;
        if (containsData.booleanValue()) {
            this.image.setSelector(".img");
            return this.image.getSrc();
        }
        return "";
    }

    @Override
    public String getStyles() {
        String style = "";
        String width = this.getWidth();
        String height = this.getHeight();
        style = style + (width.length() > 0 ? "width:" + width + "%;" : "");
        style = style + (height.length() > 0 ? "height:" + height + "px;" : "");
        return style;
    }

    public String getDropTargetClass() throws RepositoryException {
        if (this.image.getData() == null) {
            return "cq-placeholder cq-dd-image";
        }
        return "cq-dd-image";
    }

    public String getAltText() {
        String altText = this.externalize((String)this.resourceProps.get("altText", (Object)""), "altText");
        if ("".equals(altText)) {
            String title = this.externalize((String)this.resourceProps.get("jcr:title", (Object)""), "jcr:title");
            altText = "".equals(title) ? this.externalize((String)this.resourceProps.get("name", (Object)""), "name") : title;
        }
        return GuideUtils.filterHtml(altText, this.getXssapi());
    }

    @Override
    public String getHeight() {
        return (String)this.resourceProps.get("height", (Object)"");
    }

    @Override
    public String getGuideFieldType() {
        return "guideImage";
    }
}

