/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.dermis.authentication.model;

import com.adobe.aemfd.dermis.authentication.api.IAuthenticationConfig;
import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class BasicAuthenticationConfig
implements IAuthenticationConfig {
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthenticationConfig.class);
    @OSGiService
    private CryptoSupport cryptoSupport;
    @Inject
    private String userName;
    @Inject
    private String password;
    @Inject
    @Optional
    @Default(booleanValues={false})
    private Boolean addNonce = false;
    @Inject
    @Optional
    @Default(intValues={0})
    private int timeToLive;
    @Inject
    private String dataSourceType;
    @Inject
    @Optional
    private String headerInfoBasic;
    @Inject
    @Optional
    @Default(booleanValues={false})
    private boolean addCreatedTime;
    @Inject
    @Optional
    @Default(booleanValues={false})
    private boolean passwordDigest;

    public BasicAuthenticationConfig() {
    }

    public BasicAuthenticationConfig(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        String decryptedPassword = null;
        if (this.cryptoSupport != null) {
            try {
                decryptedPassword = this.cryptoSupport.unprotect(this.password);
            }
            catch (CryptoException cryptoException) {
                DermisLogger.logErrorAndDebug(BasicAuthenticationConfig.class, "Error while decrypting the Password", (Exception)((Object)cryptoException));
            }
        }
        return decryptedPassword;
    }

    public void setPassword(String password) {
        if (this.cryptoSupport != null) {
            try {
                this.password = this.cryptoSupport.protect(password);
            }
            catch (CryptoException cryptoException) {
                DermisLogger.logErrorAndDebug(BasicAuthenticationConfig.class, "Error while encrypting the Password", (Exception)((Object)cryptoException));
            }
        }
    }

    public boolean addNonce() {
        return this.addNonce;
    }

    public boolean addCreatedTime() {
        return this.addCreatedTime;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isPasswordDigest() {
        return this.passwordDigest;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public String getHeaderInfoBasic() {
        return this.headerInfoBasic;
    }

    public void setDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void setHeaderInfoBasic(String headerInfoBasic) {
        this.headerInfoBasic = headerInfoBasic;
    }
}

