/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.dermis.authentication.model;

import com.adobe.aemfd.dermis.authentication.api.IAuthenticationConfig;
import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class TokenAuthenticationConfig
implements IAuthenticationConfig {
    private static final Logger logger = LoggerFactory.getLogger(TokenAuthenticationConfig.class);
    @OSGiService
    private CryptoSupport cryptoSupport;
    @Inject
    private String apiKey;
    @Inject
    private String paramName;
    @Inject
    private String location;

    public TokenAuthenticationConfig() {
    }

    public TokenAuthenticationConfig(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    public String getApiKey() {
        String decryptedApiKey = null;
        if (this.cryptoSupport != null) {
            try {
                decryptedApiKey = this.cryptoSupport.unprotect(this.apiKey);
            }
            catch (CryptoException cryptoException) {
                DermisLogger.logErrorAndDebug(TokenAuthenticationConfig.class, "Error while decrypting the API Key", (Exception)((Object)cryptoException));
            }
        }
        return decryptedApiKey;
    }

    public void setApiKey(String apiKey) {
        if (this.cryptoSupport != null) {
            try {
                this.apiKey = this.cryptoSupport.protect(apiKey);
            }
            catch (CryptoException cryptoException) {
                DermisLogger.logErrorAndDebug(TokenAuthenticationConfig.class, "Error while encrypting the API Key", (Exception)((Object)cryptoException));
            }
        }
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

