/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class PreferencesMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = 5077148185712605242L;

    protected abstract Object getPrefValueFromString(String var1, String var2);

    public abstract PreferencesMap newInstance();

    protected abstract PreferencesMap createChild(String var1);

    protected String[] getNonCloneableKeys() {
        return null;
    }

    private List<String> getNonCloneableKeyList() {
        String[] nCKs = this.getNonCloneableKeys();
        if (nCKs != null) {
            ArrayList<String> output = new ArrayList<String>();
            for (String nCK : nCKs) {
                output.add(nCK.toLowerCase());
            }
            return output;
        }
        return null;
    }

    @Override
    public Object clone() {
        PreferencesMap newMap = this.newInstance();
        List<String> nonCloneableKeys = this.getNonCloneableKeyList();
        for (String key : this.keySet()) {
            Object value = this.get(key);
            if (value instanceof PreferencesMap) {
                newMap.put(key, ((PreferencesMap)value).clone());
                continue;
            }
            if (value != null) {
                if (nonCloneableKeys != null && nonCloneableKeys.contains(key.toLowerCase())) {
                    newMap.put(key, value);
                    continue;
                }
                newMap.put(key, (Object)value.toString());
                continue;
            }
            newMap.put(key, (Object)null);
        }
        return newMap;
    }

    @Override
    public final Object put(String prefName, Object prefValue) {
        if (prefName == null) {
            return null;
        }
        if (prefValue instanceof String) {
            return super.put(prefName.toLowerCase(), this.getPrefValueFromString(prefName, (String)prefValue));
        }
        return super.put(prefName.toLowerCase(), prefValue);
    }

    public final Object get(String key) {
        return super.get(key.toLowerCase());
    }

    public Object getPreference(String key) {
        String myKey;
        if (key == null) {
            return null;
        }
        int dotIndex = key.indexOf(46);
        String string = myKey = dotIndex == -1 ? key : key.substring(0, dotIndex);
        if (myKey == null || myKey.equals("")) {
            return null;
        }
        Object value = this.get(myKey);
        if (dotIndex != -1 && value instanceof PreferencesMap) {
            return ((PreferencesMap)value).getPreference(key.substring(dotIndex + 1));
        }
        return value;
    }

    public void setPreference(String key, Object value) {
        if (key == null) {
            return;
        }
        int dotIndex = key.indexOf(46);
        if (dotIndex == -1) {
            this.put(key, value);
        } else {
            String myKey = key.substring(0, dotIndex);
            if (myKey == null || myKey.equals("")) {
                return;
            }
            Object tVal = this.get(myKey);
            if (tVal == null) {
                tVal = this.createChild(myKey);
            }
            if (tVal != null) {
                ((PreferencesMap)tVal).setPreference(key.substring(dotIndex + 1), value);
            }
        }
    }
}

