/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.SSLUtils;
import com.adobe.forms.foundation.wsdl.WSDLInvokerParams;
import com.adobe.granite.keystore.KeyStoreService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class AuthenticatedResourceLocator {
    protected final Logger logger = LoggerFactory.getLogger(AuthenticatedResourceLocator.class);
    Map<String, String> httpHeaders;
    private static HttpClientBuilderFactory httpClientBuilderFactory;

    public AuthenticatedResourceLocator(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public static void setHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        AuthenticatedResourceLocator.httpClientBuilderFactory = httpClientBuilderFactory;
    }

    public InputSource getResource(URL url) throws IOException, URISyntaxException {
        HttpClient httpClient = this.getHttpClient();
        return this.executeHttpRequest(httpClient, url);
    }

    public InputSource getResource(URL url, KeyStoreService keyStoreService, ResourceResolverFactory resourceResolverFactory, WSDLInvokerParams wsdlInvokerParams) throws Exception {
        HttpClient httpClient = null;
        boolean isHttps = url.toString().toLowerCase().startsWith("https");
        boolean isMutualSSLAuthentication = false;
        String mutualSSLKeyAlias = null;
        if (wsdlInvokerParams != null) {
            isMutualSSLAuthentication = wsdlInvokerParams.isMutualSSL();
            mutualSSLKeyAlias = wsdlInvokerParams.getMutualSSLKeyAlias();
        }
        if (isHttps && keyStoreService != null && resourceResolverFactory != null && isMutualSSLAuthentication) {
            SSLContext sslContext = SSLUtils.getSSLContext(resourceResolverFactory, "readCloudService", "sslFDM", keyStoreService, keyStoreService, mutualSSLKeyAlias);
            httpClient = HttpClientBuilder.create().setSslcontext(sslContext).build();
        } else {
            httpClient = this.getHttpClient();
        }
        try {
            return this.executeHttpRequest(httpClient, url);
        }
        catch (Exception e) {
            this.logger.error("error occurred while getting resource : ", (Throwable)e);
            throw e;
        }
    }

    private HttpGet getRequest(URL url) throws URISyntaxException {
        HttpGet request = null;
        if (url != null) {
            request = new HttpGet(url.toURI());
            for (String headerName : this.httpHeaders.keySet()) {
                request.setHeader(headerName, this.httpHeaders.get(headerName));
            }
        }
        return request;
    }

    private HttpClient getHttpClient() {
        HttpClientBuilder builder = httpClientBuilderFactory.newBuilder();
        CloseableHttpClient httpClient = builder.build();
        return httpClient;
    }

    private InputSource executeHttpRequest(HttpClient httpClient, URL url) throws URISyntaxException, IOException {
        InputSource inputSource = null;
        HttpGet request = this.getRequest(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        if (entity.getContent() != null) {
            inputSource = new InputSource(entity.getContent());
        }
        return inputSource;
    }
}

