/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTrustManager
implements X509TrustManager {
    private static Logger logger = LoggerFactory.getLogger(CustomTrustManager.class);
    X509TrustManager jvmTrustManager;
    X509TrustManager aemTrustManager;

    CustomTrustManager(X509TrustManager jvmTrustManager, X509TrustManager aemTrustManager) {
        this.jvmTrustManager = jvmTrustManager;
        this.aemTrustManager = aemTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.jvmTrustManager.checkClientTrusted(x509Certificates, s);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            logger.debug("certificate checking with jvm trust store");
            this.jvmTrustManager.checkServerTrusted(x509Certificates, s);
        }
        catch (CertificateException e) {
            logger.debug("certificate checking with aem trust store");
            this.aemTrustManager.checkServerTrusted(x509Certificates, s);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

