/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.CustomTrustManager;
import com.adobe.granite.keystore.KeyStoreService;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SSLUtils.class);
    static TrustManagerFactory trustManagerFactory;

    private static KeyManager[] getKeyManager(KeyStoreService keyStoreService, ResourceResolver resourceResolver, String mutualSSLKeyAlias) {
        try {
            if (StringUtils.isEmpty((CharSequence)mutualSSLKeyAlias)) {
                KeyManager keyManager = keyStoreService.getKeyManager(resourceResolver);
                return new KeyManager[]{keyManager};
            }
            KeyStore keyStore = null;
            String keyPassword = "changeit";
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStoreService.getKeyStoreEntry(resourceResolver, resourceResolver.getUserID(), mutualSSLKeyAlias);
            Certificate cert = entry.getCertificate();
            PrivateKey privateKey = entry.getPrivateKey();
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("client-cert", cert);
            keyStore.setKeyEntry("client-key", privateKey, keyPassword.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPassword.toCharArray());
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            logger.error("error occurred while creating keymanager: ", (Throwable)e);
            return null;
        }
    }

    private static TrustManager[] getTrustManager(KeyStoreService keyStoreService, ResourceResolver resourceResolver) {
        try {
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] jvmTrustManagers = trustManagerFactory.getTrustManagers();
            TrustManager aemTrustManager = keyStoreService.getTrustManager(resourceResolver);
            TrustManager jvmTrustManager = null;
            for (TrustManager trustManager : jvmTrustManagers) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                jvmTrustManager = trustManager;
            }
            if (aemTrustManager != null) {
                CustomTrustManager customTrustManager = new CustomTrustManager((X509TrustManager)jvmTrustManager, (X509TrustManager)aemTrustManager);
                return new TrustManager[]{customTrustManager};
            }
            return jvmTrustManagers;
        }
        catch (Exception e) {
            logger.error("error occurred while creating trustmanager: ", (Throwable)e);
            return null;
        }
    }

    private static ResourceResolver getResourceResolver(ResourceResolverFactory resourceResolverFactory, String subService) throws LoginException {
        HashMap<String, String> authenticationInfo = new HashMap<String, String>();
        authenticationInfo.put("sling.service.subservice", subService);
        ResourceResolver resourceResolver = resourceResolverFactory.getServiceResourceResolver(authenticationInfo);
        return resourceResolver;
    }

    public static SSLContext getSSLContext(ResourceResolverFactory resourceResolverFactory, String keySubService, String trustSubService, KeyStoreService keyStoreService, KeyStoreService trustStoreService, String mutualSSLKeyAlias) throws LoginException, NoSuchAlgorithmException, KeyManagementException {
        long startTs = System.nanoTime();
        ResourceResolver keyResourceResolver = SSLUtils.getResourceResolver(resourceResolverFactory, keySubService);
        ResourceResolver trustResourceResolver = SSLUtils.getResourceResolver(resourceResolverFactory, trustSubService);
        KeyManager[] keyManager = SSLUtils.getKeyManager(keyStoreService, keyResourceResolver, mutualSSLKeyAlias);
        TrustManager[] trustManager = SSLUtils.getTrustManager(trustStoreService, trustResourceResolver);
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(keyManager, trustManager, new SecureRandom());
        logger.trace("SSL context performance measure : " + (System.nanoTime() - startTs));
        return sslContext;
    }

    static {
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

