/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.wsdl.AuthenticatedResourceLocator;
import com.adobe.forms.foundation.wsdl.SubstitutionGroupBean;
import com.adobe.forms.foundation.wsdl.WSDLInvoker;
import com.adobe.forms.foundation.wsdl.WSDLInvokerInternalObject;
import com.adobe.forms.foundation.wsdl.WSDLInvokerParams;
import com.adobe.forms.foundation.wsdl.WSDLResponse;
import com.adobe.granite.keystore.KeyStoreService;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, label="WSDL Invoker")
@Service(value={WSDLInvokerService.class})
public class WSDLInvokerService {
    private static final String SCHEMA = "schema";
    private static final String DEFINITION = "definition";
    private static final String SCHEMA_SET = "schemaset";
    private static final int CACHE_SIZE = 100;
    private Map<String, Map<String, Object>> schemaCache = Collections.synchronizedMap(new LinkedHashMap<String, Map<String, Object>>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Map<String, Object>> eldest) {
            return this.size() > 100;
        }
    });
    private SOAPConnectionFactory soapConnectionFactory;
    protected final Logger log = LoggerFactory.getLogger(WSDLInvokerService.class);
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;
    @Reference
    private KeyStoreService keyStoreService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    protected void activate(ComponentContext componentContext) {
        try {
            this.soapConnectionFactory = SOAPConnectionFactory.newInstance();
        }
        catch (SOAPException e) {
            this.log.error("Unable to create Soap connection factory ", (Throwable)e);
        }
    }

    protected void bindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        AuthenticatedResourceLocator.setHttpClientBuilderFactory(httpClientBuilderFactory);
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    public void clearCache(String serverEndPoint) {
        this.schemaCache.remove(serverEndPoint);
    }

    public String executeOperation(String serverEndPoint, String operation, String jsonInput, WSDLInvokerParams params) throws Exception {
        WSDLInvokerInternalObject internalObj = new WSDLInvokerInternalObject();
        internalObj.setParams(params);
        WSDLInvoker invoker = new WSDLInvoker(this.soapConnectionFactory);
        return invoker.executeOperation(internalObj, serverEndPoint, operation, jsonInput);
    }

    public String executeOperation(String serverEndPoint, String operation, LinkedHashMap<String, Object> argumentInput, WSDLInvokerParams params) throws Exception {
        WSDLInvokerInternalObject internalObj = this.prepareWSDLInvokerInternalObject(serverEndPoint, params);
        WSDLInvoker invoker = new WSDLInvoker(this.soapConnectionFactory, this.keyStoreService, this.resourceResolverFactory);
        String result = invoker.executeOperation(internalObj, serverEndPoint, operation, argumentInput);
        this.populateSchemaCache(serverEndPoint, internalObj);
        return result;
    }

    public WSDLResponse executeOperationForSoapResponse(String serverEndPoint, String operation, LinkedHashMap<String, Object> argumentInput, WSDLInvokerParams params) throws Exception {
        WSDLInvokerInternalObject internalObj = this.prepareWSDLInvokerInternalObject(serverEndPoint, params);
        WSDLInvoker invoker = new WSDLInvoker(this.soapConnectionFactory, this.keyStoreService, this.resourceResolverFactory);
        WSDLResponse wsdlResponse = invoker.executeOperationForSoapResponse(internalObj, serverEndPoint, operation, argumentInput);
        this.populateSchemaCache(serverEndPoint, internalObj);
        return wsdlResponse;
    }

    public String expandAllOperations(String serverEndPoint, WSDLInvokerParams params) throws Exception {
        WSDLInvokerInternalObject internalObj = new WSDLInvokerInternalObject();
        internalObj.setParams(params);
        WSDLInvoker invoker = new WSDLInvoker(this.soapConnectionFactory);
        return invoker.expandAllOperations(serverEndPoint, internalObj);
    }

    public String expandAllOperationsAndEntities(String serverEndPoint, WSDLInvokerParams params) throws Exception {
        WSDLInvokerInternalObject internalObj = new WSDLInvokerInternalObject();
        internalObj.setParams(params);
        WSDLInvoker invoker = new WSDLInvoker(this.soapConnectionFactory, this.keyStoreService, this.resourceResolverFactory);
        return invoker.expandAllOperationsAndEntities(serverEndPoint, internalObj);
    }

    public Map<String, List<SubstitutionGroupBean>> getAllSubstitutionGroups(String serverEndPoint, WSDLInvokerParams params) throws Exception {
        WSDLInvokerInternalObject wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        wsdlInvokerInternalObject.setParams(params);
        wsdlInvokerInternalObject.setEndPoint(serverEndPoint);
        try {
            Map<String, Object> schema = null;
            if (this.schemaCache.containsKey(serverEndPoint)) {
                schema = this.schemaCache.get(serverEndPoint);
                wsdlInvokerInternalObject.setDefinition((Definition)schema.get(DEFINITION));
                wsdlInvokerInternalObject.setSchemaObject((XSSchema)schema.get(SCHEMA));
                wsdlInvokerInternalObject.setmSchemaSet((XSSchemaSet)schema.get(SCHEMA_SET));
            }
        }
        catch (Exception e) {
            this.log.error("exception occurred while getting schema from cache for substitution groups : ", (Throwable)e);
        }
        WSDLInvoker invoker = new WSDLInvoker(this.soapConnectionFactory, this.keyStoreService, this.resourceResolverFactory);
        return invoker.getAllSubstitutionGroups(wsdlInvokerInternalObject);
    }

    private void populateSchemaCache(String serverEndPoint, WSDLInvokerInternalObject internalObj) {
        HashMap<String, Object> schema = null;
        if (!this.schemaCache.containsKey(serverEndPoint)) {
            schema = new HashMap<String, Object>();
            schema.put(DEFINITION, internalObj.getDefinition());
            schema.put(SCHEMA_SET, internalObj.getmSchemaSet());
            schema.put(SCHEMA, internalObj.getSchemaObject());
            this.schemaCache.put(serverEndPoint, schema);
        }
    }

    private WSDLInvokerInternalObject prepareWSDLInvokerInternalObject(String serverEndPoint, WSDLInvokerParams params) {
        WSDLInvokerInternalObject internalObj = new WSDLInvokerInternalObject();
        internalObj.setParams(params);
        Map<String, Object> schema = null;
        if (this.schemaCache.containsKey(serverEndPoint)) {
            schema = this.schemaCache.get(serverEndPoint);
            internalObj.setDefinition((Definition)schema.get(DEFINITION));
            internalObj.setSchemaObject((XSSchema)schema.get(SCHEMA));
            internalObj.setmSchemaSet((XSSchemaSet)schema.get(SCHEMA_SET));
        }
        return internalObj;
    }

    protected void unbindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        if (this.httpClientBuilderFactory == httpClientBuilderFactory) {
            this.httpClientBuilderFactory = null;
        }
    }

    protected void bindKeyStoreService(KeyStoreService keyStoreService) {
        this.keyStoreService = keyStoreService;
    }

    protected void unbindKeyStoreService(KeyStoreService keyStoreService) {
        if (this.keyStoreService == keyStoreService) {
            this.keyStoreService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

