/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.seata.feign;

import com.alibaba.cloud.seata.feign.SeataFeignBlockingLoadBalancerClient;
import com.alibaba.cloud.seata.feign.SeataFeignClient;
import feign.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;

public class SeataFeignObjectWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SeataFeignObjectWrapper.class);
    private final BeanFactory beanFactory;

    SeataFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof SeataFeignClient)) {
            if (bean instanceof FeignBlockingLoadBalancerClient) {
                FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)bean;
                return new SeataFeignBlockingLoadBalancerClient(client.getDelegate(), (BlockingLoadBalancerClient)this.beanFactory.getBean(BlockingLoadBalancerClient.class), (LoadBalancerClientFactory)this.beanFactory.getBean(LoadBalancerClientFactory.class), this);
            }
            return new SeataFeignClient(this.beanFactory, (Client)bean);
        }
        return bean;
    }
}

