/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.InstanceProfileCredentials;
import com.aliyun.oss.common.auth.InstanceProfileCredentialsFetcher;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyuncs.exceptions.ClientException;
import java.util.concurrent.locks.ReentrantLock;

public class InstanceProfileCredentialsProvider
implements CredentialsProvider {
    private final String roleName;
    private InstanceProfileCredentials credentials;
    private InstanceProfileCredentialsFetcher fetcher;
    private int maxRetryTimes = 3;
    private ReentrantLock lock = new ReentrantLock();

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new InstanceProfileCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withCredentialsFetcher(InstanceProfileCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InstanceProfileCredentials getCredentials() {
        if (this.credentials == null || this.credentials.isExpired()) {
            try {
                this.lock.lock();
                if (this.credentials != null && !this.credentials.isExpired()) return this.credentials;
                try {
                    this.credentials = (InstanceProfileCredentials)this.fetcher.fetch(this.maxRetryTimes);
                    return this.credentials;
                }
                catch (ClientException e) {
                    LogUtils.logException("EcsInstanceCredentialsFetcher.fetch Exception:", e);
                    InstanceProfileCredentials instanceProfileCredentials = null;
                    this.lock.unlock();
                    return instanceProfileCredentials;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.credentials.willSoonExpire() || !this.credentials.shouldRefresh()) return this.credentials;
        try {
            this.lock.lock();
            if (!this.credentials.willSoonExpire() || !this.credentials.shouldRefresh()) return this.credentials;
            try {
                this.credentials = (InstanceProfileCredentials)this.fetcher.fetch();
                return this.credentials;
            }
            catch (ClientException e) {
                this.credentials.setLastFailedRefreshTime();
                LogUtils.logException("EcsInstanceCredentialsFetcher.fetch Exception:", e);
            }
            return this.credentials;
        }
        finally {
            this.lock.unlock();
        }
    }
}

