/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.SourceTableDetails;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SourceTableDetailsMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<String> TABLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableId").build();
    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").build();
    private static final MarshallingInfo<Long> TABLESIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableSizeBytes").build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").build();
    private static final MarshallingInfo<Date> TABLECREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableCreationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").build();
    private static final SourceTableDetailsMarshaller instance = new SourceTableDetailsMarshaller();

    public static SourceTableDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceTableDetails sourceTableDetails, ProtocolMarshaller protocolMarshaller) {
        if (sourceTableDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceTableDetails.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.getTableId(), TABLEID_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.getTableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.getTableSizeBytes(), TABLESIZEBYTES_BINDING);
            protocolMarshaller.marshall(sourceTableDetails.getKeySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.getTableCreationDateTime(), TABLECREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.getProvisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.getItemCount(), ITEMCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

