/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.transfer.model.ListedAgreement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAgreementsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ListedAgreement> agreements;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAgreementsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ListedAgreement> getAgreements() {
        return this.agreements;
    }

    public void setAgreements(Collection<ListedAgreement> agreements) {
        if (agreements == null) {
            this.agreements = null;
            return;
        }
        this.agreements = new ArrayList<ListedAgreement>(agreements);
    }

    public ListAgreementsResult withAgreements(ListedAgreement ... agreements) {
        if (this.agreements == null) {
            this.setAgreements(new ArrayList<ListedAgreement>(agreements.length));
        }
        for (ListedAgreement ele : agreements) {
            this.agreements.add(ele);
        }
        return this;
    }

    public ListAgreementsResult withAgreements(Collection<ListedAgreement> agreements) {
        this.setAgreements(agreements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getAgreements() != null) {
            sb.append("Agreements: ").append(this.getAgreements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgreementsResult)) {
            return false;
        }
        ListAgreementsResult other = (ListAgreementsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getAgreements() == null ^ this.getAgreements() == null) {
            return false;
        }
        return other.getAgreements() == null || other.getAgreements().equals(this.getAgreements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getAgreements() == null ? 0 : this.getAgreements().hashCode());
        return hashCode;
    }

    public ListAgreementsResult clone() {
        try {
            return (ListAgreementsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

