/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.artifact;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.artifact.MutableArtifactImpl;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.plan.PlanKeys;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="artifacts", itemNodeName="artifact")
public class ArtifactMapper
extends BambooStAXMappingListHelperAbstractImpl<MutableArtifact, MutableArtifact>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ArtifactMapper.class);
    static final String LABEL = "label";
    static final String SIZE = "size";
    static final String ARTIFACT = "sharedArtifact";
    static final String GLOBALLY_STORED = "globallyStored";
    static final String TYPE = "type";
    static final String PLAN_RESULT_KEY = "planResultKey";
    static final String ARCHIVER_TYPE = "archiverType";
    private ArtifactDao artifactDao;

    public ArtifactMapper(SessionFactory sessionFactory, ArtifactDao artifactDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.artifactDao = artifactDao;
    }

    @Override
    @NotNull
    protected MutableArtifact createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new MutableArtifactImpl();
    }

    @Override
    protected void importProperties(@NotNull MutableArtifact artifact, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(artifact, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (LABEL.equals(elementLocalName)) {
            artifact.setLabel(inputCursor.getElemStringValue());
        } else if (SIZE.equals(elementLocalName)) {
            artifact.setSize(Long.valueOf(inputCursor.getElemLongValue()));
        } else if (ARTIFACT.equals(elementLocalName)) {
            artifact.setSharedArtifact(inputCursor.getElemBooleanValue());
        } else if (TYPE.equals(elementLocalName)) {
            artifact.setLinkType(inputCursor.getElemStringValue());
        } else if (PLAN_RESULT_KEY.equals(elementLocalName)) {
            artifact.setPlanResultKey(PlanKeys.getPlanResultKey((String)inputCursor.getElemStringValue()));
        } else if (GLOBALLY_STORED.equals(elementLocalName)) {
            artifact.setGloballyStored(inputCursor.getElemBooleanValue());
        } else if (ARCHIVER_TYPE.equals(elementLocalName)) {
            artifact.setArchiverType(ArchiverType.values()[inputCursor.getElemIntValue()]);
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull MutableArtifact artifact, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, artifact, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(LABEL, artifact.getLabel()).append(ARTIFACT, artifact.isSharedArtifact()).append(GLOBALLY_STORED, artifact.isGloballyStored()).appendIfNotBlank(TYPE, artifact.getLinkType()).append(SIZE, artifact.getSize()).append(PLAN_RESULT_KEY, (ResultKey)artifact.getPlanResultKey()).append(ARCHIVER_TYPE, artifact.getArchiverType().ordinal());
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<MutableArtifact> artifactDefinitions, @NotNull MutableArtifact object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.artifactDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

