/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.artifact.MutableArtifactImpl;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.build.artifact.DefaultArtifactLink;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.beans.DummyResultsSummaryCache;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="artifactLinks", itemNodeName="artifactLink")
public class ArtifactLinkMapper
extends BambooStAXMappingListHelperAbstractImpl<ArtifactLink, ArtifactLink>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ArtifactLinkMapper.class);
    static final String LABEL = "label";
    static final String SIZE = "size";
    static final String ARTIFACT = "sharedArtifact";
    static final String TYPE = "type";
    static final String RESULTS_SUMMARY = "resultsSummary";
    static final String PRODUCER_JOB_RESULT = "producerJobResult";
    static final String ARTIFACT_ID = "artifactId";
    final ArtifactLinkDao artifactLinkDao;
    private final ArtifactDao artifactDao;
    private final DummyResultsSummaryCache dummyResultsSummaryCache;

    public ArtifactLinkMapper(SessionFactory sessionFactory, ArtifactLinkDao artifactLinkDao, ArtifactDao artifactDao, DummyResultsSummaryCache dummyResultsSummaryCache, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.artifactLinkDao = artifactLinkDao;
        this.dummyResultsSummaryCache = dummyResultsSummaryCache;
        this.artifactDao = artifactDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    protected DefaultArtifactLink createItemInstance(SMInputCursor inputCursor) throws Exception {
        DefaultArtifactLink defaultArtifactLink = new DefaultArtifactLink();
        defaultArtifactLink.setArtifact((MutableArtifact)new MutableArtifactImpl());
        return defaultArtifactLink;
    }

    @Override
    protected void importProperties(@NotNull ArtifactLink object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        if (object instanceof DefaultArtifactLink) {
            DefaultArtifactLink artifactLink = (DefaultArtifactLink)object;
            MutableArtifactImpl artifact = (MutableArtifactImpl)artifactLink.getArtifact();
            String elementLocalName = inputCursor.getLocalName();
            if (LABEL.equals(elementLocalName)) {
                artifact.setLabel(inputCursor.getElemStringValue());
            } else if (SIZE.equals(elementLocalName)) {
                artifact.setSize(Long.valueOf(inputCursor.getElemLongValue()));
            } else if (ARTIFACT.equals(elementLocalName)) {
                artifact.setSharedArtifact(inputCursor.getElemBooleanValue());
            } else if (TYPE.endsWith(elementLocalName)) {
                artifact.setLinkType(inputCursor.getElemStringValue());
            } else if (RESULTS_SUMMARY.equals(elementLocalName)) {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)inputCursor.getElemStringValue());
                BuildResultsSummary resultsSummary = this.dummyResultsSummaryCache.get(planResultKey);
                artifact.setPlanResultKey(planResultKey);
                artifactLink.setBuildResultsSummary((ResultsSummary)resultsSummary);
            } else if (PRODUCER_JOB_RESULT.equals(elementLocalName)) {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)inputCursor.getElemStringValue());
                BuildResultsSummary resultsSummary = this.dummyResultsSummaryCache.get(planResultKey);
                artifactLink.setProducerJobResult(resultsSummary);
            } else if (ARTIFACT_ID.equals(elementLocalName)) {
                long id = inputCursor.getElemLongValue();
                MutableArtifactImpl mutableArtifact = new MutableArtifactImpl();
                mutableArtifact.setId(id);
                artifactLink.setArtifact((MutableArtifact)mutableArtifact);
            }
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ArtifactLink object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        if (object instanceof DefaultArtifactLink) {
            DefaultArtifactLink artifactLink = (DefaultArtifactLink)object;
            new SMOutputElementAppender(outputElement).append(ARTIFACT_ID, artifactLink.getArtifact().getId()).appendIfNotBlank(RESULTS_SUMMARY, artifactLink.getBuildResultsSummary() != null ? artifactLink.getBuildResultsSummary().getPlanResultKey().toString() : null).appendIfNotBlank(PRODUCER_JOB_RESULT, artifactLink.getProducerJobResult() != null ? artifactLink.getProducerJobResult().getPlanResultKey().toString() : null);
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ArtifactLink> artifactDefinitions, @NotNull ArtifactLink object, long objectIndex, @NotNull Session session) throws Exception {
        if (object.getArtifact().getId() < 0L) {
            this.saveBambooObject(session, (BambooIdProvider)object.getArtifact());
        }
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.artifactLinkDao.scrollArtifactLinksForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

