/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.migration.stream;

import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.dao.AgentAssignmentDao;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.AgentAssignmentImpl;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="agentAssignments", itemNodeName="assignment")
public class AgentAssignmentMapper
extends BambooStAXMappingListHelperAbstractImpl<AgentAssignment, AgentAssignment>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AgentAssignmentMapper.class);
    private static final String NODE_EXECUTOR_ID = "executorId";
    private static final String NODE_EXECUTOR_TYPE = "executorType";
    private static final String NODE_EXECUTABLE_ID = "executableId";
    private static final String NODE_EXECUTABLE_TYPE = "executableType";
    private final AgentAssignmentDao agentAssignmentDao;

    public AgentAssignmentMapper(SessionFactory sessionFactory, AgentAssignmentDao agentAssignmentDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.agentAssignmentDao = agentAssignmentDao;
    }

    @Override
    @NotNull
    protected AgentAssignment createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new AgentAssignmentImpl();
    }

    @Override
    protected void importProperties(@NotNull AgentAssignment agentAssignment, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(agentAssignment, inputCursor, session);
        AgentAssignmentImpl impl = (AgentAssignmentImpl)Narrow.downTo((Object)agentAssignment, AgentAssignmentImpl.class);
        Preconditions.checkArgument((impl != null ? 1 : 0) != 0, (Object)"Bad class of agentAssignment");
        assert (impl != null);
        String elementName = inputCursor.getLocalName();
        if (NODE_EXECUTOR_ID.equals(elementName)) {
            impl.setExecutorId(inputCursor.getElemLongValue());
        } else if (NODE_EXECUTOR_TYPE.equals(elementName)) {
            impl.setExecutorType(AgentAssignment.ExecutorType.valueOf((String)inputCursor.getElemStringValue()));
        } else if (NODE_EXECUTABLE_ID.equals(elementName)) {
            impl.setExecutableId(inputCursor.getElemLongValue());
        } else if (NODE_EXECUTABLE_TYPE.equals(elementName)) {
            impl.setExecutableType(AgentAssignment.ExecutableType.valueOf((String)inputCursor.getElemStringValue()));
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull AgentAssignment agentAssignment, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, agentAssignment, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(NODE_EXECUTOR_ID, agentAssignment.getExecutorId()).append(NODE_EXECUTOR_TYPE, (Enum)agentAssignment.getExecutorType()).append(NODE_EXECUTABLE_ID, agentAssignment.getExecutableId()).append(NODE_EXECUTABLE_TYPE, (Enum)agentAssignment.getExecutableType());
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<AgentAssignment> list, @NotNull AgentAssignment agentAssignment, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)agentAssignment);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.agentAssignmentDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

