/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.credentials.CredentialsDataEntity;
import com.atlassian.bamboo.credentials.MutableCredentialsData;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="credentials", itemNodeName="credential")
public class CredentialMapper
extends BambooStAXMappingListHelperAbstractImpl<MutableCredentialsData, MutableCredentialsData>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(CredentialMapper.class);
    static final String NAME = "name";
    static final String PLUGIN_KEY = "pluginKey";
    static final String XML_CFG = "xml";
    static final String PROJECT_ID = "projectId";
    private CredentialsDao credentialsDao;

    public CredentialMapper(SessionFactory sessionFactory, CredentialsDao credentialsDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.credentialsDao = credentialsDao;
    }

    @Override
    @NotNull
    protected MutableCredentialsData createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new CredentialsDataEntity();
    }

    @Override
    protected void importProperties(@NotNull MutableCredentialsData credentialsData, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(credentialsData, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (NAME.equals(elementLocalName)) {
            credentialsData.setName(inputCursor.getElemStringValue());
        } else if (PLUGIN_KEY.equals(elementLocalName)) {
            credentialsData.setPluginKey(inputCursor.getElemStringValue());
        } else if (XML_CFG.equals(elementLocalName)) {
            credentialsData.setXml(inputCursor.getElemStringValue());
        } else if (PROJECT_ID.equals(elementLocalName)) {
            credentialsData.setProjectId(Long.valueOf(inputCursor.getElemLongValue()));
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull MutableCredentialsData credentialsData, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, credentialsData, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(NAME, credentialsData.getName()).append(PLUGIN_KEY, credentialsData.getPluginKey()).appendCData(XML_CFG, credentialsData.getXml()).appendIfNotNull(PROJECT_ID, credentialsData.getProjectId());
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<MutableCredentialsData> artifactDefinitions, @NotNull MutableCredentialsData object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.credentialsDao.findAll(MutableCredentialsData.class), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

