/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelper;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BambooStAXListImportStrategy {
    NO_TRANSACTION{

        @Override
        protected <T, I extends T> long importListItems(@NotNull TransactionOperations transactionOperations, @NotNull Session session, @NotNull SMInputCursor listItemCursor, @NotNull BambooStAXMappingListHelper<T, I> mappingHelper, @NotNull List<I> itemList, @NotNull String displayNodeName) throws Exception {
            SMEvent event;
            long importedItemIndex = 0L;
            while ((event = listItemCursor.getNext()) != null) {
                if (event != SMEvent.START_ELEMENT) continue;
                BambooStAXListImportStrategy.importListItemXml(session, listItemCursor, mappingHelper, itemList, ++importedItemIndex, displayNodeName);
            }
            return importedItemIndex;
        }
    }
    ,
    LIST_ITEM_TRANSACTION{

        @Override
        protected <T, I extends T> long importListItems(@NotNull TransactionOperations transactionOperations, final @NotNull Session session, final @NotNull SMInputCursor listItemCursor, final @NotNull BambooStAXMappingListHelper<T, I> mappingHelper, final @NotNull List<I> itemList, final @NotNull String displayNodeName) throws Exception {
            SMEvent event;
            final AtomicLong importedItemIndex = new AtomicLong();
            while ((event = listItemCursor.getNext()) != null) {
                if (event != SMEvent.START_ELEMENT) continue;
                transactionOperations.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus status) {
                        try {
                            BambooStAXListImportStrategy.importListItemXml(session, listItemCursor, mappingHelper, itemList, importedItemIndex.incrementAndGet(), displayNodeName);
                            session.flush();
                        }
                        catch (Exception e) {
                            log.warn((Object)String.format("Exception during processing %s #%d", displayNodeName, importedItemIndex.get()), (Throwable)e);
                            throw BambooObjectUtils.asRuntimeException((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            return importedItemIndex.get();
        }
    }
    ,
    LIST_10000_ITEMS_TRANSACTION{

        @Override
        protected <T, I extends T> long importListItems(@NotNull TransactionOperations transactionOperations, final @NotNull Session session, final @NotNull SMInputCursor listItemCursor, final @NotNull BambooStAXMappingListHelper<T, I> mappingHelper, final @NotNull List<I> itemList, final @NotNull String displayNodeName) throws Exception {
            final AtomicLong importedItemIndex = new AtomicLong();
            while (((Boolean)transactionOperations.execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    try {
                        SMEvent event;
                        while ((event = listItemCursor.getNext()) != null) {
                            if (event == SMEvent.START_ELEMENT) {
                                BambooStAXListImportStrategy.importListItemXml(session, listItemCursor, mappingHelper, itemList, importedItemIndex.incrementAndGet(), displayNodeName);
                            }
                            if (importedItemIndex.get() % 10000L != 0L) continue;
                            session.flush();
                            return true;
                        }
                        session.flush();
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("Exception during processing %s #%d", displayNodeName, importedItemIndex.get()), (Throwable)e);
                        throw BambooObjectUtils.asRuntimeException((Throwable)e);
                    }
                    return false;
                }
            })).booleanValue()) {
            }
            return importedItemIndex.get();
        }
    }
    ,
    LIST_TRANSACTION{

        @Override
        protected <T, I extends T> long importListItems(@NotNull TransactionOperations transactionOperations, final @NotNull Session session, final @NotNull SMInputCursor listItemCursor, final @NotNull BambooStAXMappingListHelper<T, I> mappingHelper, final @NotNull List<I> itemList, final @NotNull String displayNodeName) throws Exception {
            return (Long)transactionOperations.execute((TransactionCallback)new TransactionCallback<Long>(){

                public Long doInTransaction(TransactionStatus status) {
                    long importedItemIndex = 0L;
                    try {
                        SMEvent event;
                        while ((event = listItemCursor.getNext()) != null) {
                            if (event != SMEvent.START_ELEMENT) continue;
                            BambooStAXListImportStrategy.importListItemXml(session, listItemCursor, mappingHelper, itemList, ++importedItemIndex, displayNodeName);
                        }
                        session.flush();
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("Exception during processing %s #%d", displayNodeName, importedItemIndex), (Throwable)e);
                        throw BambooObjectUtils.asRuntimeException((Throwable)e);
                    }
                    return importedItemIndex;
                }
            });
        }
    }
    ,
    LIST_ITEM_AND_CLEAR_SESSION_TRANSACTION{

        @Override
        protected <T, I extends T> long importListItems(@NotNull TransactionOperations transactionOperations, final @NotNull Session session, final @NotNull SMInputCursor listItemCursor, final @NotNull BambooStAXMappingListHelper<T, I> mappingHelper, final @NotNull List<I> itemList, final @NotNull String displayNodeName) throws Exception {
            SMEvent event;
            final AtomicLong importedItemIndex = new AtomicLong();
            while ((event = listItemCursor.getNext()) != null) {
                if (event != SMEvent.START_ELEMENT) continue;
                transactionOperations.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus status) {
                        try {
                            BambooStAXListImportStrategy.importListItemXml(session, listItemCursor, mappingHelper, itemList, importedItemIndex.incrementAndGet(), displayNodeName);
                            session.flush();
                            session.clear();
                        }
                        catch (Exception e) {
                            log.warn((Object)String.format("Exception during processing %s #%d", displayNodeName, importedItemIndex.get()), (Throwable)e);
                            throw BambooObjectUtils.asRuntimeException((Throwable)e);
                        }
                        return null;
                    }
                });
            }
            return importedItemIndex.get();
        }
    };

    private static final Logger log;
    public static final long DEFAULT_DISPLAY_PROGRESS_STEP;

    protected abstract <T, I extends T> long importListItems(@NotNull TransactionOperations var1, @NotNull Session var2, @NotNull SMInputCursor var3, @NotNull BambooStAXMappingListHelper<T, I> var4, @NotNull List<I> var5, @NotNull String var6) throws Exception;

    public <T, I extends T> List<I> importListXml(TransactionOperations transactionOperations, @NotNull Session session, @NotNull SMInputCursor inputCursor, @NotNull BambooStAXMappingListHelper<T, I> mappingHelper) throws Exception {
        ArrayList list = new ArrayList();
        if (inputCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
            String displayNodeName = String.format("%s.%s", inputCursor.getLocalName(), mappingHelper.getXmlElementNodeName());
            SMInputCursor listItemCursor = inputCursor.childElementCursor(mappingHelper.getXmlElementNodeName());
            try {
                long importedItemCount = this.importListItems(transactionOperations, session, listItemCursor, mappingHelper, list, displayNodeName);
                if (importedItemCount > DEFAULT_DISPLAY_PROGRESS_STEP) {
                    log.info((Object)String.format("Importing %s: finished", displayNodeName));
                }
            }
            catch (Exception e) {
                throw new BambooImportException("Exception was caught during import in mapper " + mappingHelper, e);
            }
        }
        return list;
    }

    private static <T, I extends T> void importListItemXml(@NotNull Session session, @NotNull SMInputCursor listItemCursor, @NotNull BambooStAXMappingListHelper<T, I> mappingHelper, @NotNull List<I> list, long importedItemIndex, @NotNull String displayNodeName) throws Exception {
        mappingHelper.beforeImportListItem(listItemCursor, list, session);
        Object object = mappingHelper.importXml(session, listItemCursor);
        mappingHelper.afterImportListItem(listItemCursor, list, object, importedItemIndex, session);
        if (importedItemIndex % DEFAULT_DISPLAY_PROGRESS_STEP == 0L) {
            log.info((Object)String.format("Importing %s: %d, used memory %d MB", displayNodeName, importedItemIndex, (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L));
        }
    }

    static {
        log = Logger.getLogger(BambooStAXMappingHelperAbstractImpl.class);
        DEFAULT_DISPLAY_PROGRESS_STEP = SystemProperty.IMPORT_REPORT_PROGRESS_STEP_PROPERTY.getTypedValue();
    }
}

