/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXMappingHelper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ItemMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class BambooStAXMappingHelperAbstractImpl<T, I extends T>
implements BambooStAXMappingHelper<T, I> {
    private static final Logger log = Logger.getLogger(BambooStAXMappingHelperAbstractImpl.class);
    private final SessionFactory sessionFactory;
    protected final TransactionOperations transactionOperations;

    protected BambooStAXMappingHelperAbstractImpl(SessionFactory sessionFactory, TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
        this.sessionFactory = sessionFactory;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        ItemMapper annotation = this.getClass().getAnnotation(ItemMapper.class);
        return ((ItemMapper)Preconditions.checkNotNull((Object)annotation)).rootNodeName();
    }

    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return true;
    }

    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull T object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        if (object instanceof EntityObject) {
            MapperUtil.exportDefaults(outputElement, object);
        }
    }

    protected final void exportXml(@NotNull SMOutputElement outputElement, @NotNull T object, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportXml(this.getSession(), outputElement, object, exportDetailsBean);
    }

    @Override
    public void exportXml(@NotNull Session session, @NotNull SMOutputElement outputElement, @NotNull T object, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createRootElement(outputElement);
        this.exportProperties(rootElement, object, session, exportDetailsBean);
    }

    @NotNull
    protected abstract I createItemInstance(SMInputCursor var1) throws Exception;

    protected void importProperties(@NotNull I object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof EntityObject) {
            MapperUtil.importDefaults(object, inputCursor);
        }
    }

    @NotNull
    protected final I importXml(@NotNull SMInputCursor inputCursor) throws Exception {
        return this.importXml(this.getSession(), inputCursor);
    }

    @Override
    @NotNull
    public I importXml(@NotNull Session session, @NotNull SMInputCursor inputCursor) throws Exception {
        I object = this.createItemInstance(inputCursor);
        if (inputCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
            SMEvent event;
            SMInputCursor childCursor = inputCursor.childElementCursor();
            while ((event = childCursor.getNext()) != null) {
                if (event != SMEvent.START_ELEMENT) continue;
                this.importProperties(object, childCursor, session);
            }
        }
        return object;
    }

    @NotNull
    protected SMOutputElement createRootElement(@NotNull SMOutputElement outputElement) throws XMLStreamException {
        return outputElement.addElement(this.getXmlRootNodeName());
    }

    protected void saveBambooObject(@NotNull Session session, @NotNull BambooIdProvider object) throws HibernateException {
        long id = object.getId();
        if (id <= 0L) {
            session.save((Object)object);
        } else {
            HibernateDaoUtils.save((Session)session, (Object)object, (Serializable)Long.valueOf(id));
        }
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

