/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public abstract class BambooStAXMappingListHelperAbstractImpl<T, I extends T>
extends BambooStAXMappingHelperAbstractImpl<T, I>
implements BambooStAXMappingListHelper<T, I> {
    private static final Logger log = Logger.getLogger(BambooStAXMappingListHelperAbstractImpl.class);
    private final BambooStAXListImportStrategy listImportStrategy;

    protected BambooStAXMappingListHelperAbstractImpl(SessionFactory sessionFactory, BambooStAXListImportStrategy listImportStrategy, TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.listImportStrategy = listImportStrategy;
    }

    protected BambooStAXMappingListHelperAbstractImpl(SessionFactory sessionFactory, TransactionOperations transactionOperations) {
        this(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        ListMapper annotation = this.getClass().getAnnotation(ListMapper.class);
        return ((ListMapper)Preconditions.checkNotNull((Object)annotation)).itemNodeName();
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        ListMapper annotation = this.getClass().getAnnotation(ListMapper.class);
        return ((ListMapper)Preconditions.checkNotNull((Object)annotation)).rootNodeName();
    }

    @Override
    public void beforeImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<I> list, @NotNull Session session) throws Exception {
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<I> list, @NotNull I object, long objectIndex, @NotNull Session session) throws Exception {
        list.add(object);
    }

    @NotNull
    protected SMOutputElement createListRootElement(@NotNull SMOutputElement outputElement) throws XMLStreamException {
        return outputElement.addElement(this.getXmlRootNodeName());
    }

    @Override
    @NotNull
    protected SMOutputElement createRootElement(@NotNull SMOutputElement outputElement) throws XMLStreamException {
        return outputElement.addElement(this.getXmlElementNodeName());
    }

    public final <E extends T> void exportListXml(@NotNull SMOutputElement outputElement, @NotNull Iterable<E> iterable, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(this.getSession(), outputElement, iterable, exportDetailsBean);
    }

    @Override
    public <E extends T> void exportListXml(@NotNull Session session, @NotNull SMOutputElement outputElement, @NotNull Iterable<E> iterable, ExportDetailsBean exportDetailsBean) throws Exception {
        if (iterable.iterator().hasNext()) {
            SMOutputElement rootElement = this.createListRootElement(outputElement);
            for (E object : iterable) {
                this.exportXml(session, rootElement, object, exportDetailsBean);
            }
        }
    }

    @NotNull
    public final List<I> importListXml(@NotNull SMInputCursor inputCursor) throws Exception {
        return this.importListXml(this.getSession(), inputCursor);
    }

    @Override
    @NotNull
    public List<I> importListXml(@NotNull Session session, @NotNull SMInputCursor inputCursor) throws Exception {
        return this.listImportStrategy.importListXml(this.transactionOperations, session, inputCursor, this);
    }

    protected void importListXmlInTransaction(final SMInputCursor inputCursor) {
        this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    Session session = BambooStAXMappingListHelperAbstractImpl.this.getSession();
                    BambooStAXMappingListHelperAbstractImpl.this.importListXml(session, inputCursor);
                    session.flush();
                }
                catch (Exception e) {
                    throw BambooObjectUtils.asRuntimeException((Throwable)e);
                }
            }
        });
    }

    protected void eventEndElementOfListItemSaveObject(@NotNull Session session, @NotNull T object, long objectIndex, long flushSize) throws HibernateException {
        EntityObject entityObject = (EntityObject)object;
        HibernateDaoUtils.save((Session)session, (Object)entityObject, (Serializable)Long.valueOf(entityObject.getId()));
        this.flushIfNeeded(session, objectIndex, flushSize);
    }

    protected void flushIfNeeded(Session session, long objectIndex, long flushSize) throws HibernateException {
        if (objectIndex % flushSize == 0L) {
            session.flush();
            session.clear();
        }
    }
}

