/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.migration.exception.BambooImportException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class ImportContext<T> {
    private static final Logger log = Logger.getLogger(ImportContext.class);
    private final ThreadLocal<T> value = new ThreadLocal();
    private final String name;

    private ImportContext(@NotNull String name) {
        this.name = name;
    }

    public T get() throws BambooImportException {
        T result = this.value.get();
        if (result == null) {
            throw new BambooImportException(String.format("Error accessing %s, value not set", this.name));
        }
        return result;
    }

    public void set(T value) throws BambooImportException {
        T previousValue = this.value.get();
        if (previousValue != null && previousValue != value) {
            throw new BambooImportException(String.format("Error setting %s, previous value not cleared", this.name));
        }
        this.value.set(value);
    }

    public void clear() {
        this.value.remove();
    }

    public static <T> ImportContext<T> create(@NotNull String name) {
        return new ImportContext<T>(name);
    }
}

