/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.ClusterAwareLifecycleManager;
import com.atlassian.bamboo.NodeLifecycleState;
import com.atlassian.bamboo.buildqueue.manager.BambooBusyException;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ImportExportManager;
import com.atlassian.bamboo.migration.XmlMigrator;
import com.atlassian.bamboo.migration.beans.DummyResultsSummaryCache;
import com.atlassian.bamboo.migration.utils.BambooResetableHiLoGeneratorHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.web.utils.JohnsonEventContainerHolder;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.xwork2.TextProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportExportManagerImpl
implements ImportExportManager {
    private static final Logger log = Logger.getLogger(ImportExportManagerImpl.class);
    private final XmlMigrator xmlMigrator;
    private final TextProvider textProvider;
    private final AdminErrorHandler adminErrorHandler;
    private final DeletionService deletionService;
    private final DummyResultsSummaryCache dummyResultsSummaryCache;
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private final ClusterAwareLifecycleManager clusterAwareLifecycleManager;
    @Autowired
    private BambooResetableHiLoGeneratorHelper bambooResetableHiLoGeneratorHelper;

    public ImportExportManagerImpl(DeletionService deletionService, XmlMigrator xmlMigrator, TextProvider textProvider, AdminErrorHandler adminErrorHandler, DummyResultsSummaryCache dummyResultsSummaryCache, ImmutablePlanCacheService immutablePlanCacheService, ClusterAwareLifecycleManager clusterAwareLifecycleManager) {
        this.deletionService = deletionService;
        this.xmlMigrator = xmlMigrator;
        this.textProvider = textProvider;
        this.adminErrorHandler = adminErrorHandler;
        this.dummyResultsSummaryCache = dummyResultsSummaryCache;
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.clusterAwareLifecycleManager = clusterAwareLifecycleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bambooExport(ExportDetailsBean exportDetails) throws Exception {
        try {
            Event appEvent = new Event(EventType.get((String)"export"), this.textProvider.getText("export.inprogress"), EventLevel.get((String)"warning"));
            JohnsonEventContainer johnsonEventContainer = JohnsonEventContainerHolder.getInstance();
            boolean exportPaused = false;
            try {
                this.deletionService.suspendDeletions();
                if (this.clusterAwareLifecycleManager.getNodeLifecycleState() != NodeLifecycleState.PAUSED) {
                    exportPaused = true;
                    CompletableFuture pauseServerFuture = this.clusterAwareLifecycleManager.pauseCluster();
                    if (exportDetails.isAwaitJobCompletion()) {
                        try {
                            if (pauseServerFuture.get(this.getWaitTimeout(), TimeUnit.MILLISECONDS) != NodeLifecycleState.PAUSED) {
                                log.warn((Object)"Proceeding with export despite server not being stopped");
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"Proceeding with export despite server not being stopped", (Throwable)e);
                        }
                    }
                }
                johnsonEventContainer.addEvent(appEvent);
                this.xmlMigrator.exportXml(exportDetails);
            }
            finally {
                this.deletionService.resumeDeletions();
                if (exportPaused) {
                    this.clusterAwareLifecycleManager.resumeCluster();
                }
                johnsonEventContainer.removeEvent(appEvent);
            }
        }
        catch (BambooBusyException exception) {
            String message = this.textProvider.getText("export.error.busy");
            log.error((Object)message);
            throw new Exception(message);
        }
    }

    public void bambooImport(String path) throws Exception {
        this.bambooImport(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bambooOsgiDependentImport(String path) throws Exception {
        try {
            try {
                JohnsonEventContainer johnsonEventContainer = JohnsonEventContainerHolder.getInstance();
                try {
                    Event appEvent = new Event(EventType.get((String)"import"), this.textProvider.getText("import.inprogress"), EventLevel.get((String)"warning"));
                    try {
                        johnsonEventContainer.addEvent(appEvent);
                        this.clusterAwareLifecycleManager.pauseCluster();
                        this.immutablePlanCacheService.disableCache();
                        this.xmlMigrator.importXmlOsgiDependent(path);
                    }
                    finally {
                        this.dummyResultsSummaryCache.invalidateAll();
                        johnsonEventContainer.removeEvent(appEvent);
                    }
                }
                catch (Exception exception) {
                    Event fatalEvent = new Event(EventType.get((String)"import"), this.textProvider.getText("import.error.failed.johnson.message", new String[]{StringEscapeUtils.escapeHtml4((String)ExceptionUtils.getStackTrace((Throwable)exception))}), EventLevel.get((String)"fatal"));
                    johnsonEventContainer.addEvent(fatalEvent);
                    throw exception;
                }
            }
            catch (Exception e) {
                this.adminErrorHandler.recordError("import.error.failed", this.textProvider.getText("import.error.failed") + ": " + e);
                log.error((Object)"Exception occurred during import", (Throwable)e);
                throw new Exception(this.textProvider.getText("import.error.failed"), e);
            }
        }
        catch (BambooBusyException exception) {
            String message = this.textProvider.getText("import.error.busy");
            log.error((Object)message);
            throw new Exception(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bambooImport(String path, boolean clearArtifacts) throws Exception {
        try {
            try {
                JohnsonEventContainer johnsonEventContainer = JohnsonEventContainerHolder.getInstance();
                try {
                    Event appEvent = new Event(EventType.get((String)"import"), this.textProvider.getText("import.inprogress"), EventLevel.get((String)"warning"));
                    try {
                        johnsonEventContainer.addEvent(appEvent);
                        this.clusterAwareLifecycleManager.pauseCluster();
                        this.immutablePlanCacheService.disableCache();
                        this.xmlMigrator.importXml(path, clearArtifacts);
                    }
                    finally {
                        this.dummyResultsSummaryCache.invalidateAll();
                        johnsonEventContainer.removeEvent(appEvent);
                    }
                }
                catch (RuntimeException exception) {
                    Event fatalEvent = new Event(EventType.get((String)"import"), this.textProvider.getText("import.error.failed.johnson.message", new String[]{StringEscapeUtils.escapeHtml4((String)ExceptionUtils.getStackTrace((Throwable)exception))}), EventLevel.get((String)"fatal"));
                    johnsonEventContainer.addEvent(fatalEvent);
                    throw exception;
                }
            }
            catch (RuntimeException e) {
                this.adminErrorHandler.recordError("import.error.failed", this.textProvider.getText("import.error.failed") + ": " + e);
                log.error((Object)"Exception occurred during import", (Throwable)e);
                throw new Exception(this.textProvider.getText("import.error.failed"), e);
            }
        }
        catch (BambooBusyException exception) {
            String message = this.textProvider.getText("import.error.busy");
            log.error((Object)message);
            throw new Exception(message);
        }
    }

    public void validateImport(String path) throws Exception {
        this.xmlMigrator.validateXml(path);
    }

    public void resetGenerators() {
        this.bambooResetableHiLoGeneratorHelper.resetGenerators();
    }

    @VisibleForTesting
    long getWaitTimeout() {
        return SystemProperty.EXPORT_WAIT_FOR_SERVER_PAUSE_TIMEOUT.getTypedValue();
    }
}

