/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.EntityWithOid;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapperUtil {
    private static final Logger log = Logger.getLogger(MapperUtil.class);
    public static final String GENERIC_XML_ID = "id";
    public static final String GENERIC_XML_OID = "oid";
    public static final String GENERIC_XML_CREATIONDATE = "creationDate";
    public static final String GENERIC_XML_MODIFICATIONDATE = "modificationDate";
    @Deprecated
    private static final String LEGACY_DATE_FORMAT_STRING = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static volatile Locale cachedLocale = Locale.getDefault();

    public static void addElementIfNotBlank(@NotNull Element element, @NotNull String elementName, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            element.addElement(elementName).addText(value);
        }
    }

    public static void addElementIfNotBlank(@NotNull Element element, @NotNull String elementName, boolean value) {
        MapperUtil.addElementIfNotBlank(element, elementName, String.valueOf(value));
    }

    public static void addElementIfNotBlank(@NotNull Element element, @NotNull String elementName, int value) {
        MapperUtil.addElementIfNotBlank(element, elementName, String.valueOf(value));
    }

    public static void addElementIfNotBlank(@NotNull Element element, @NotNull String elementName, long value) {
        MapperUtil.addElementIfNotBlank(element, elementName, String.valueOf(value));
    }

    public static void exportDefaults(Object object, Element element) throws IllegalArgumentException, ParseException {
        EntityWithOid entityWithOid;
        EntityObject entityObject = MapperUtil.toEntityObject(object);
        Date creationDate = entityObject.getCreationDate();
        Date modificationDate = entityObject.getLastModificationDate();
        element.addElement(GENERIC_XML_ID).addText(Long.toString(entityObject.getId()));
        Element creationElement = element.addElement(GENERIC_XML_CREATIONDATE);
        Element modificationElement = element.addElement(GENERIC_XML_MODIFICATIONDATE);
        if (creationDate != null) {
            creationElement.addText(BambooDateUtils.dateToPortableString((Date)creationDate));
        }
        if (modificationDate != null) {
            modificationElement.addText(BambooDateUtils.dateToPortableString((Date)modificationDate));
        }
        if ((entityWithOid = (EntityWithOid)Narrow.downTo((Object)entityObject, EntityWithOid.class)) != null) {
            Element oidElement = element.addElement(GENERIC_XML_OID);
            oidElement.addText(Long.toString(entityWithOid.getOid().getValue()));
        }
    }

    public static void exportDefaults(@NotNull SMOutputElement outputElement, @Nullable Object object) throws XMLStreamException {
        EntityWithOid entityWithOid;
        EntityObject entityObject = MapperUtil.toEntityObject(object);
        Date creationDate = entityObject.getCreationDate();
        Date modificationDate = entityObject.getLastModificationDate();
        outputElement.addElement(GENERIC_XML_ID).addValue(entityObject.getId());
        if (creationDate != null) {
            outputElement.addElement(GENERIC_XML_CREATIONDATE).addCharacters(BambooDateUtils.dateToPortableString((Date)creationDate));
        }
        if (modificationDate != null) {
            outputElement.addElement(GENERIC_XML_MODIFICATIONDATE).addCharacters(BambooDateUtils.dateToPortableString((Date)modificationDate));
        }
        if ((entityWithOid = (EntityWithOid)Narrow.downTo((Object)entityObject, EntityWithOid.class)) != null) {
            outputElement.addElement(GENERIC_XML_OID).addValue(entityWithOid.getOid().getValue());
        }
    }

    public static void importDefaults(@Nullable Object object, @NotNull SMInputCursor inputCursor) throws XMLStreamException {
        EntityObject entityObject = MapperUtil.toEntityObject(object);
        if (inputCursor.getCurrEvent() == SMEvent.START_ELEMENT && inputCursor.getLocalName() != null) {
            switch (inputCursor.getLocalName()) {
                case "id": {
                    entityObject.setId(inputCursor.getElemLongValue());
                    break;
                }
                case "creationDate": {
                    entityObject.setCreationDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
                    break;
                }
                case "modificationDate": {
                    entityObject.setLastModificationDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
                    break;
                }
                case "oid": {
                    EntityWithOid entityWithOid = (EntityWithOid)Narrow.downTo((Object)entityObject, EntityWithOid.class);
                    if (entityWithOid == null) break;
                    entityWithOid.setOid(BambooEntityOid.create((long)inputCursor.getElemLongValue()));
                }
            }
        }
    }

    @Nullable
    public static Date parseDateElement(Element element) {
        if (element == null) {
            return null;
        }
        return MapperUtil.parseDateElement(element.getText());
    }

    @Nullable
    public static Date parseDateElement(SMInputCursor inputCursor) throws XMLStreamException {
        if (inputCursor == null) {
            return null;
        }
        return MapperUtil.parseDateElement(inputCursor.getElemStringValue());
    }

    public static <T extends EntityObject> T createFakeObject(@NotNull Class<T> objectClass, @NotNull SMInputCursor inputCursor) throws XMLStreamException, IllegalAccessException, InstantiationException {
        EntityObject fakeObject = (EntityObject)objectClass.newInstance();
        fakeObject.setId(inputCursor.getElemLongValue());
        return (T)fakeObject;
    }

    @Nullable
    public static Date parseDateElement(@Nullable String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        try {
            return BambooDateUtils.portableDateStringToDate((String)dateString);
        }
        catch (ParseException exception) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(LEGACY_DATE_FORMAT_STRING, cachedLocale);
            try {
                return dateFormat.parse(dateString);
            }
            catch (ParseException exception2) {
                for (Locale locale : Locale.getAvailableLocales()) {
                    SimpleDateFormat dateFormat2 = new SimpleDateFormat(LEGACY_DATE_FORMAT_STRING, locale);
                    try {
                        Date date = dateFormat2.parse(dateString);
                        log.info((Object)("Import locale appears to be " + locale));
                        cachedLocale = locale;
                        return date;
                    }
                    catch (ParseException parseException) {
                    }
                }
                throw new IllegalArgumentException("Could not parse \"" + dateString + "\"");
            }
        }
    }

    public static boolean matchesElement(@NotNull BambooStAXMappingHelperAbstractImpl mapper, @NotNull String elementName) throws XMLStreamException {
        return mapper.getXmlRootNodeName().equals(elementName);
    }

    public static boolean matchesElement(@NotNull BambooStAXMappingListHelperAbstractImpl mapper, @NotNull String elementName) throws XMLStreamException {
        return mapper.getXmlRootNodeName().equals(elementName);
    }

    public static <T, I extends T> Consumer<T> exportXmlFunction(final @NotNull BambooStAXMappingHelperAbstractImpl<T, I> mapper, final @NotNull SMOutputElement rootElement, final ExportDetailsBean exportDetailsBean) {
        return new Consumer<T>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable T entity) {
                if (entity != null) {
                    try {
                        mapper.exportXml(rootElement, entity, exportDetailsBean);
                        if (++this.index % 10000L == 0L) {
                            log.info((Object)String.format("Exporting %s: %d", entity.getClass().getName(), this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + entity), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        };
    }

    public static <T, I extends T> Consumer<T> exportXmlConsumer(final @NotNull BambooStAXMappingHelperAbstractImpl<T, I> mapper, final @NotNull SMOutputElement rootElement, final ExportDetailsBean exportDetailsBean) {
        return new Consumer<T>(){
            private long index = 0L;

            @Override
            public void accept(T entity) {
                try {
                    mapper.exportXml(rootElement, entity, exportDetailsBean);
                    if (++this.index % 10000L == 0L) {
                        log.info((Object)String.format("Exporting %s: %d", entity.getClass().getName(), this.index));
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Could not export " + entity), (Throwable)e);
                    throw new MapperExportException(e);
                }
            }
        };
    }

    @NotNull
    private static EntityObject toEntityObject(Object object) {
        Preconditions.checkArgument((boolean)(object instanceof EntityObject), (Object)"Object needs to be an EntityObject");
        return (EntityObject)object;
    }
}

