/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.core.bean.EntityObject;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.out.SMOutputElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMOutputElementAppender {
    private static final Logger log = Logger.getLogger(SMOutputElementAppender.class);
    private static final String CDATA_TRAILER = "]]>";
    private final SMOutputElement outputElement;

    public SMOutputElementAppender(SMOutputElement outputElement) {
        this.outputElement = outputElement;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, @NotNull String value) throws XMLStreamException {
        this.outputElement.addElement(elementName).addCharacters(value);
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, boolean value) throws XMLStreamException {
        this.outputElement.addElement(elementName).addValue(value);
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, int value) throws XMLStreamException {
        this.outputElement.addElement(elementName).addValue(value);
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, long value) throws XMLStreamException {
        this.outputElement.addElement(elementName).addValue(value);
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, @Nullable EntityObject entityObject) throws XMLStreamException {
        if (entityObject != null) {
            this.outputElement.addElement(elementName).addValue(entityObject.getId());
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, @Nullable Key key) throws XMLStreamException {
        if (key != null) {
            return this.append(elementName, key.getKey());
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, @Nullable ResultKey resultKey) throws XMLStreamException {
        if (resultKey != null) {
            return this.append(elementName, resultKey.getKey());
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender append(@NotNull String elementName, @Nullable Enum value) throws XMLStreamException {
        if (value != null) {
            return this.append(elementName, value.name());
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender appendIfNotBlank(@NotNull String elementName, @Nullable String value) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return this.append(elementName, value);
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender appendIfNotEqual(@NotNull String elementName, String value, String defaultValue) throws XMLStreamException {
        if (!defaultValue.equals(value)) {
            return this.append(elementName, value);
        }
        return this;
    }

    @NotNull
    public <T extends Enum<T>> SMOutputElementAppender appendIfNotNull(@NotNull String elementName, @Nullable T value) throws XMLStreamException {
        if (value != null) {
            return this.append(elementName, value.name());
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender appendIfNotNull(@NotNull String elementName, @Nullable Date value) throws XMLStreamException {
        if (value != null) {
            return this.append(elementName, BambooDateUtils.dateToPortableString((Date)value));
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender appendIfNotNull(@NotNull String elementName, @Nullable Date value, @NotNull TimeZone timeZone) throws XMLStreamException {
        if (value != null) {
            return this.append(elementName, BambooDateUtils.dateToPortableString((Date)value, (TimeZone)timeZone));
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender appendIfNotNull(@NotNull String elementName, @Nullable Number value) throws XMLStreamException {
        if (value != null) {
            return this.append(elementName, value.toString());
        }
        return this;
    }

    @NotNull
    public SMOutputElementAppender appendCData(@NotNull String elementName, @Nullable String value) throws XMLStreamException {
        this.addCData(this.outputElement.addElement(elementName), StringUtils.defaultString((String)value));
        return this;
    }

    private void addCData(@NotNull SMOutputElement outputElement, @NotNull String value) throws XMLStreamException {
        int indexOfCDataTrailer = value.indexOf(CDATA_TRAILER);
        if (indexOfCDataTrailer == -1) {
            outputElement.addCData(value);
        } else {
            this.addCData(outputElement, value.substring(0, indexOfCDataTrailer + 1));
            this.addCData(outputElement, value.substring(indexOfCDataTrailer + 1));
        }
    }
}

