/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration;

import com.atlassian.activeobjects.spi.HotRestartService;
import com.atlassian.bamboo.beehive.BambooClusterLockService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.hibernate.BambooSchemaHelper;
import com.atlassian.bamboo.migration.BambooRootMapper;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.BambooStreamRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.migration.stream.userdata.LocalUserMapper;
import com.atlassian.bamboo.migration.utils.BambooResetableHiLoGeneratorHelper;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.location.ArtifactPathBuilderFactoryImpl;
import com.atlassian.bamboo.upgrade.UpgradeUtilityBean;
import com.atlassian.bamboo.util.BambooIOUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.cache.CacheManager;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.crowd.embedded.EmbeddedCrowdBootstrap;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.xml.XMLConfigurationParser;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.ctc.wstx.sw.BambooWstxInputFactory;
import com.ctc.wstx.sw.BambooWstxOutputFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.SMOutputFactory;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputDocument;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XmlMigrator {
    private static final Logger log = Logger.getLogger(XmlMigrator.class);
    private static final String DB_XML = "administrationConfiguration.xml";
    private static final String XML_ROOT = "bamboo";
    private static final String BAMBOO_XML_DATE = "date";
    private static final String BAMBOO_XML_VERSION = "version";
    private static final String BAMBOO_XML_BUILD_NUMBER = "build";
    private static final String BAMBOO_XML_BUILD_DATE = "buildDate";
    private static final String RESULTS_DIRECTORY_NAME = "results";
    private static final String ZIP_BUILD_DIR = "builds";
    private static final String ZIP_ARTIFACTS_DIR = "artifacts";
    private static final String ZIP_CONFIG_DIR = "configuration";
    private static final String ZIP_REPOSITORY_SPECS_DIR = "repository-specs";
    private static final String ZIP_DB_EXPORT_DIR = "db-export";
    private static final String ZIP_BAMBOO_HOME_DIR = "bamboo-home";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy");
    private static final TArchiveDetector DETECTOR = new TArchiveDetector("zip", (FsDriver)new JarDriver((IOPoolProvider)IOPoolLocator.SINGLETON));
    private final BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;
    private static final String ATLASSIAN_USER_FILE = "atlassian-user.xml";
    private static final RepositoryIdentifier HIBERNATE_REPOSITORY_IDENTIFIER = new DefaultRepositoryIdentifier("hibernateRepository", "Hibernate Repository");
    private List<BambooRootMapper> exporters;
    private List<BambooRootMapper> importers;
    private List<BambooRootMapper> osgiDependentImporters;
    private List<BambooRootMapper> headerImporters;
    private BootstrapManager bootstrapManager;
    private BambooSchemaHelper schemaHelper;
    private CacheManager cacheManager;
    private SessionFactory sessionFactory;
    private Persister persister;
    @Inject
    private EmbeddedCrowdBootstrap embeddedCrowdBootstrap;
    @Inject
    private BambooClusterLockService bambooClusterLockService;
    @Inject
    private BambooResetableHiLoGeneratorHelper resettableHiLoGeneratorHelper;
    private ApplicationConfiguration applicationConfig;
    private UpgradeUtilityBean upgradeUtilityBean;
    private final Supplier<DbmsBean> dbmsBeanRef = ComponentAccessor.DBMS_BEAN;
    private final Supplier<HotRestartService> aoHotRestartService = ComponentAccessor.newOsgiServiceProxy(HotRestartService.class);
    private BandanaPersister bandanaPersister;
    Map<TFile, Boolean> utf8ComplianceMap = new HashMap<TFile, Boolean>();

    public XmlMigrator(BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate) {
        this.bambooTransactionHibernateTemplate = bambooTransactionHibernateTemplate;
    }

    public synchronized void importXml(String path, boolean clearArtifacts) throws Exception {
        Stopwatch stopWatch = Stopwatch.createStarted();
        this.validateXml(path);
        String baseUrl = this.persister.getAdministrationConfiguration().getBaseUrl();
        Path buildDirectory = Paths.get(this.bootstrapManager.getBuildDirectory(), new String[0]);
        Path buildWorkingDirectory = SystemDirectory.getBaseBuildWorkingDirectory().toPath();
        Path configDirectory = Paths.get(this.bootstrapManager.getConfigDirectory(), new String[0]);
        Path artifactsDirectory = ArtifactPathBuilderFactoryImpl.getRootArtifactDirectory((BootstrapManager)this.bootstrapManager).toPath();
        try {
            if (Files.exists(buildWorkingDirectory, new LinkOption[0])) {
                log.info((Object)"Deleting build working directory.");
                BambooPathUtils.deleteDirectory((Path)buildWorkingDirectory);
            }
            if (Files.exists(buildDirectory, new LinkOption[0])) {
                log.info((Object)"Deleting builds directory.");
                BambooPathUtils.cleanDirectory((Path)buildDirectory);
            }
            if (Files.exists(configDirectory, new LinkOption[0])) {
                log.info((Object)"Deleting configuration directory.");
                BambooPathUtils.cleanDirectory((Path)configDirectory);
            }
            if (clearArtifacts && Files.exists(artifactsDirectory, new LinkOption[0])) {
                log.info((Object)"Deleting artifact directory.");
                BambooPathUtils.cleanDirectory((Path)artifactsDirectory);
            }
        }
        catch (IOException e) {
            log.warn((Object)"Error deleting directories. Import halted.", (Throwable)e);
            throw e;
        }
        this.bambooTransactionHibernateTemplate.execute(session -> {
            session.flush();
            session.clear();
            try {
                this.dropAndCreateDatabase();
            }
            catch (ConfigurationException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            session.flush();
            session.clear();
            return null;
        });
        TFile zipArchive = new TFile(path, DETECTOR);
        log.info((Object)"Unzipping config directory.");
        this.unzipFolder(path, this.bootstrapManager.getConfigDirectory(), ZIP_CONFIG_DIR);
        if (this.getMapperFile(zipArchive, this.importers.stream().filter(LocalUserMapper.class::isInstance).findFirst().get()) != null) {
            boolean isInternalDirActive = this.isHibernateRepositoryPresent(zipArchive);
            this.embeddedCrowdBootstrap.initialiseEmbeddedCrowd(isInternalDirActive);
        }
        this.bambooTransactionHibernateTemplate.execute(session -> {
            try {
                this.loadXmlData(zipArchive);
            }
            catch (Exception e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            session.flush();
            session.clear();
            return null;
        });
        XmlMigrator.setNextHiValue(this.resettableHiLoGeneratorHelper);
        log.info((Object)"Creating foreign keys.");
        if (!this.dbmsBeanRef.get().isMySql() && !this.dbmsBeanRef.get().isH2()) {
            this.bambooTransactionHibernateTemplate.execute(session -> {
                XmlMigrator.createForeignKeys(session, this.dbmsBeanRef.get());
                return null;
            });
        }
        BambooPathUtils.deleteQuietly((Path)Paths.get(this.bootstrapManager.getConfigDirectory(), DB_XML));
        log.info((Object)"Unzipping builds directory.");
        this.unzipFolder(path, this.bootstrapManager.getBuildDirectory(), ZIP_BUILD_DIR);
        log.info((Object)"Unzipping artifacts directory");
        this.unzipFolder(path, this.bootstrapManager.getArtifactsDirectory(), ZIP_ARTIFACTS_DIR);
        log.info((Object)"Unzipping repository-specs directory");
        this.unzipFolder(path, this.bootstrapManager.getRepositoryLogsDirectory(), ZIP_REPOSITORY_SPECS_DIR);
        this.applicationConfig.save();
        XmlMigrator.setBaseUrl((File)new TFile(this.bootstrapManager.getConfigDirectory(), "administration.xml", DETECTOR), baseUrl);
        this.persister.reloadAdministrationConfiguration();
        log.info((Object)("Import completed. " + stopWatch));
    }

    private static void setNextHiValue(BambooResetableHiLoGeneratorHelper resettableHiLoGeneratorHelper) {
        ArrayList<String> errors = new ArrayList<String>();
        resettableHiLoGeneratorHelper.setNextHiValue(errors);
        if (!errors.isEmpty()) {
            log.error(errors);
            throw new RuntimeException(((Object)errors).toString());
        }
    }

    public synchronized void importXmlOsgiDependent(String path) throws Exception {
        Stopwatch stopWatch = Stopwatch.createStarted();
        this.validateXml(path);
        this.bambooTransactionHibernateTemplate.execute(session -> {
            session.flush();
            session.clear();
            TFile zipArchive = new TFile(path, DETECTOR);
            try {
                this.importXmlData(zipArchive, this.osgiDependentImporters);
            }
            catch (Exception e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            session.flush();
            session.clear();
            return null;
        });
        this.bambooClusterLockService.resetDatabaseState();
        RetryingTaskExecutor taskExecutor = new RetryingTaskExecutor(2, true);
        taskExecutor.runTask(() -> this.aoHotRestartService.get().doHotRestart().get());
        XmlMigrator.setNextHiValue(this.resettableHiLoGeneratorHelper);
        log.info((Object)("Import completed. " + stopWatch));
    }

    static void setBaseUrl(File administrationConfigFile, String oldBaseUrl) throws Exception {
        DocumentBuilderFactory docBuilderFactory = BambooXmlUtils.newSecureDocumentBuilderFactory((Logger)log);
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(administrationConfigFile);
            doc.normalize();
            String myBaseUrlTag = "myBaseUrl";
            NodeList myBaseUrlTags = doc.getElementsByTagName("myBaseUrl");
            if (myBaseUrlTags.getLength() > 1) {
                throw new Exception("More than one myBaseUrl tag found in " + administrationConfigFile.getAbsolutePath() + ", unable to convert");
            }
            if (myBaseUrlTags.getLength() == 0) {
                throw new Exception("myBaseUrl tag not found in " + administrationConfigFile.getAbsolutePath() + ", unable to convert");
            }
            myBaseUrlTags.item(0).setTextContent(oldBaseUrl);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer idTransform = transformerFactory.newTransformer();
            idTransform.transform(new DOMSource(doc), new StreamResult(administrationConfigFile.toURI().getPath()));
        }
        catch (Exception e) {
            log.warn((Object)"Error while updating baseUrl. Import halted.", (Throwable)e);
            throw new Exception("Error while updating baseUrl: " + e.getMessage(), e);
        }
    }

    private void loadXmlData(TFile zipArchive) throws Exception {
        if (this.importers.isEmpty()) {
            return;
        }
        this.utf8ComplianceMap.clear();
        SMInputFactory factory = new SMInputFactory(BambooXmlUtils.configure((XMLInputFactory)new BambooWstxInputFactory()));
        TFile mapperFileForHeader = this.getFirstFileWithHeader(zipArchive);
        if (mapperFileForHeader != null) {
            for (BambooStAXRootMapper mapper : Narrow.iterableTo(this.headerImporters, BambooStAXRootMapper.class)) {
                this.importFromFile(factory, mapper, mapperFileForHeader);
            }
        }
        this.bambooTransactionHibernateTemplate.execute(session -> {
            try {
                this.importXmlData(zipArchive, this.importers);
            }
            catch (Exception e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            return null;
        });
    }

    private TFile getFirstFileWithHeader(TFile zipArchive) {
        return this.importers.stream().map(i -> this.getMapperFile(zipArchive, (BambooRootMapper)i)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void importXmlData(TFile zipArchive, @NotNull Iterable<BambooRootMapper> importers) throws Exception {
        SMInputFactory factory = new SMInputFactory(BambooXmlUtils.configure((XMLInputFactory)new BambooWstxInputFactory()));
        if (BuildUtils.isDevMode()) {
            this.validateRootMappers(importers);
        }
        for (BambooRootMapper mapper : Narrow.iterableTo(importers, BambooRootMapper.class)) {
            log.info((Object)("Importing with mapper: " + mapper));
            TFile mapperFile = this.getMapperFile(zipArchive, mapper);
            if (mapperFile != null && mapperFile.exists()) {
                this.importFromFile(factory, mapper, mapperFile);
                continue;
            }
            log.warn((Object)"No file to read.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromFile(SMInputFactory factory, BambooRootMapper mapper, TFile importFile) throws Exception {
        BambooStAXRootMapper staxMapper = (BambooStAXRootMapper)Narrow.to((Object)mapper, BambooStAXRootMapper.class);
        if (staxMapper != null) {
            TFileInputStream fis = new TFileInputStream((File)importFile);
            Boolean isUtf8Compliant = this.utf8ComplianceMap.get(importFile);
            if (isUtf8Compliant == null) {
                isUtf8Compliant = BambooIOUtils.isUtf8Compliant((InputStream)fis);
                this.utf8ComplianceMap.put(importFile, isUtf8Compliant);
            }
            fis = new TFileInputStream((File)importFile);
            try {
                SMInputCursor rootCursor;
                if (isUtf8Compliant.booleanValue()) {
                    rootCursor = factory.rootElementCursor((InputStream)fis).advance();
                    rootCursor.setElementTracking(SMInputCursor.Tracking.PARENTS);
                    log.info((Object)("Reading file: " + importFile));
                    this.importData(rootCursor, staxMapper);
                } else {
                    try (InputStreamReader isr = new InputStreamReader((InputStream)fis);){
                        rootCursor = factory.rootElementCursor((Reader)isr).advance();
                        rootCursor.setElementTracking(SMInputCursor.Tracking.PARENTS);
                        log.info((Object)("Reading file in legacy scenario: " + importFile));
                        this.importData(rootCursor, staxMapper);
                    }
                    log.info((Object)("Finished reading file: " + importFile));
                }
                rootCursor.getStreamReader().closeCompletely();
            }
            finally {
                fis.close();
            }
        }
        BambooStreamRootMapper streamMapper = this.asStreamRootMapper(mapper);
        try (TFileInputStream fis = new TFileInputStream((File)importFile);){
            streamMapper.importData((InputStream)fis);
        }
    }

    private void importData(SMInputCursor rootCursor, BambooStAXRootMapper mapper) throws Exception {
        SMInputCursor mapperCursor = rootCursor.childElementCursor(mapper.getXmlRootNodeName()).advance();
        mapper.importData(mapperCursor);
    }

    public synchronized void exportXml(@NotNull ExportDetailsBean exportDetails) throws Exception {
        Stopwatch stopWatch = Stopwatch.createStarted();
        TFile zipArchive = new TFile(exportDetails.getPath(), DETECTOR);
        try {
            log.info((Object)("Creating zip:" + zipArchive.getPath()));
            zipArchive.mkdirs();
            log.info((Object)"Starting export of data...");
            TFile dbExportDirectory = new TFile((File)zipArchive, ZIP_DB_EXPORT_DIR, DETECTOR);
            dbExportDirectory.mkdirs();
            if (BuildUtils.isDevMode()) {
                this.validateRootMappers(this.exporters);
            }
            this.bambooTransactionHibernateTemplate.execute(session -> {
                try {
                    for (BambooRootMapper exporter : this.exporters) {
                        if (exporter.isShouldExport(exportDetails)) {
                            TFile exportFile = this.createMapperFile(dbExportDirectory, exporter);
                            try {
                                TFileOutputStream fos = new TFileOutputStream((File)exportFile);
                                try {
                                    log.info((Object)("Writing xml to file: " + exportFile));
                                    this.exportToStream(fos, exporter, exportDetails);
                                    log.info((Object)("Finished writing to file: " + exportFile));
                                    continue;
                                }
                                finally {
                                    fos.close();
                                    continue;
                                }
                            }
                            finally {
                                TVFS.umount((TFile)zipArchive);
                                continue;
                            }
                        }
                        log.info((Object)(exporter.getClass().getName() + " skipped from export."));
                    }
                    return null;
                }
                catch (Exception e) {
                    log.error((Object)"Problems occurred while exporting", (Throwable)e);
                    throw BambooObjectUtils.asRuntimeException((Throwable)e);
                }
            });
            TFile configDirectoryZip = new TFile(exportDetails.getPath(), ZIP_CONFIG_DIR, DETECTOR);
            log.info((Object)("Zipping config dir:" + configDirectoryZip));
            TFile.cp_rp((File)new TFile(this.bootstrapManager.getConfigDirectory()), (File)configDirectoryZip, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)DETECTOR);
            if (exportDetails.isExportResults()) {
                this.exportResultFiles(exportDetails);
            } else {
                log.info((Object)"Results not being exported...");
            }
        }
        catch (MapperExportException e) {
            log.error((Object)"Problems occurred while exporting", (Throwable)e);
            throw e;
        }
        catch (FsSyncException e) {
            log.error((Object)"Problems occurred while archiving", (Throwable)e);
            throw e;
        }
        finally {
            log.info((Object)("Updating destination zip " + zipArchive));
            TVFS.umount((TFile)zipArchive);
            log.info((Object)("Unmounted " + zipArchive));
        }
        log.info((Object)("Export completed. " + stopWatch));
    }

    private void validateRootMappers(@NotNull Iterable<BambooRootMapper> rootMappers) {
        BambooIterables.stream(rootMappers).filter(BambooStAXRootMapper.class::isInstance).map(BambooStAXRootMapper.class::cast).collect(Collectors.toMap(BambooStAXRootMapper::getXmlRootNodeName, m -> m, (l, r) -> {
            if (l.getXmlRootNodeName().equals("projects")) {
                return r;
            }
            throw new IllegalStateException(String.format("Duplicate key %s", l));
        }));
    }

    private void exportToStream(@NotNull TFileOutputStream os, @NotNull BambooRootMapper mapper, @NotNull ExportDetailsBean exportDetails) throws Exception {
        BambooStAXRootMapper staxMapper = (BambooStAXRootMapper)Narrow.to((Object)mapper, BambooStAXRootMapper.class);
        if (staxMapper != null) {
            SMOutputDocument xmlExportDocument0 = XmlMigrator.createOutputDocument((OutputStream)os);
            xmlExportDocument0.setIndentation("\n" + StringUtils.repeat((String)" ", (int)64), 1, 1);
            SMOutputElement rootElement0 = xmlExportDocument0.addElement(XML_ROOT);
            new SMOutputElementAppender(rootElement0).append(BAMBOO_XML_DATE, exportDetails.getDate().toString()).append(BAMBOO_XML_VERSION, BuildUtils.getCurrentVersion()).append(BAMBOO_XML_BUILD_DATE, DATE_FORMAT.format(BuildUtils.getCurrentBuildDate())).append(BAMBOO_XML_BUILD_NUMBER, BuildUtils.getCurrentBuildNumber()).append("serverID", this.bootstrapManager.getServerID());
            log.info((Object)("Exporting with: " + staxMapper.getClass().getName()));
            staxMapper.exportData(rootElement0, exportDetails);
            xmlExportDocument0.closeRoot();
        } else {
            this.asStreamRootMapper(mapper).exportData((OutputStream)os, exportDetails);
        }
    }

    private void exportResultFiles(ExportDetailsBean exportDetails) throws IOException {
        String artifactsDirectory;
        TFile buildDirectoryZip = new TFile(exportDetails.getPath(), ZIP_BUILD_DIR, DETECTOR);
        log.info((Object)("Zipping build dir:" + buildDirectoryZip));
        if (exportDetails.isExportArtifacts() && new File(artifactsDirectory = this.bootstrapManager.getArtifactsDirectory()).isDirectory()) {
            TFile artifactsDirectoryZip = new TFile(exportDetails.getPath(), ZIP_ARTIFACTS_DIR, DETECTOR);
            log.info((Object)("Zipping artifacts dir:" + artifactsDirectoryZip));
            TFile.cp_rp((File)new TFile(artifactsDirectory, DETECTOR), (File)artifactsDirectoryZip, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)DETECTOR);
        }
        String buildsDirectory = this.bootstrapManager.getBuildDirectory();
        if (exportDetails.isExportBuildLogs()) {
            String repositoryLogsDirectory;
            if (new File(buildsDirectory).exists()) {
                TFile.cp_rp((File)new TFile(buildsDirectory), (File)buildDirectoryZip, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)DETECTOR);
            }
            if (new File(repositoryLogsDirectory = this.bootstrapManager.getRepositoryLogsDirectory()).exists()) {
                TFile repositorySpecsLogsDirectoryZip = new TFile(exportDetails.getPath(), ZIP_REPOSITORY_SPECS_DIR, DETECTOR);
                TFile.cp_rp((File)new TFile(repositoryLogsDirectory, DETECTOR), (File)repositorySpecsLogsDirectoryZip, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)TArchiveDetector.NULL);
            }
        } else {
            TFile existingDirectory = new TFile(buildsDirectory, DETECTOR);
            TFile[] buildDirectories = existingDirectory.listFiles();
            if (buildDirectories != null) {
                for (TFile buildDirectory : buildDirectories) {
                    TFile resultsDirectory;
                    if (!buildDirectory.isDirectory() || !(resultsDirectory = new TFile((File)buildDirectory, RESULTS_DIRECTORY_NAME)).exists()) continue;
                    TFile planDirectoryZip = new TFile((File)buildDirectoryZip, buildDirectory.getName());
                    planDirectoryZip.mkdirs();
                    TFile resultsDirectoryZip = new TFile((File)planDirectoryZip, RESULTS_DIRECTORY_NAME, DETECTOR);
                    TFile.cp_rp((File)resultsDirectory, (File)resultsDirectoryZip, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)TArchiveDetector.NULL);
                }
            }
        }
    }

    static SMOutputDocument createOutputDocument(OutputStream stream) throws XMLStreamException {
        SMOutputFactory staxFactory = new SMOutputFactory((XMLOutputFactory)new BambooWstxOutputFactory());
        boolean standalone = true;
        return SMOutputFactory.createOutputDocument((XMLStreamWriter)staxFactory.createStax2Writer(stream), (String)"1.1", (String)"UTF-8", (boolean)true);
    }

    public synchronized void validateXml(String path) throws Exception {
        block10: {
            TFile zipArchive = new TFile(path, DETECTOR);
            if (!this.importers.isEmpty()) {
                Iterable topLevelImporters = Narrow.iterableTo(this.importers, BambooStAXRootMapper.class);
                Optional importerThatHasAFile = Iterables.tryFind((Iterable)topLevelImporters, importer -> this.getMapperFile(zipArchive, (BambooRootMapper)importer) != null);
                if (importerThatHasAFile.isPresent()) {
                    TFile inputFile = this.getMapperFile(zipArchive, (BambooRootMapper)importerThatHasAFile.get());
                    if (inputFile == null) {
                        throw new BambooImportException(String.format("Can't find import file for importer %s", ((BambooStAXRootMapper)importerThatHasAFile.get()).getClass().getName()));
                    }
                    try (TFileInputStream fis = new TFileInputStream((File)inputFile);){
                        String buildNumber;
                        SMInputFactory factory = new SMInputFactory(BambooXmlUtils.configure((XMLInputFactory)new BambooWstxInputFactory()));
                        SMInputCursor rootCursor = factory.rootElementCursor((InputStream)fis).advance();
                        SMInputCursor cursor = rootCursor.childElementCursor(BAMBOO_XML_BUILD_NUMBER).advance();
                        if (cursor.getCurrEvent() == SMEvent.START_ELEMENT && !this.upgradeUtilityBean.isBuildNumberApplicableForUpgrade(buildNumber = cursor.getElemStringValue())) {
                            throw new BambooImportException(String.format("Export was produced by Bamboo build %s. Import is not possible", buildNumber));
                        }
                        break block10;
                    }
                }
                if (this.isProvidedArchiveIsCloudExportZip(zipArchive)) {
                    throw new BambooImportException("Bamboo Server instances cannot be set up with the Bamboo Cloud export file. For more information, see the Server to Cloud migration guidelines.");
                }
                throw new BambooImportException("Import file is corrupted. Can't find any files to import.");
            }
            throw new BambooImportException("Can't find any importers");
        }
    }

    private boolean isProvidedArchiveIsCloudExportZip(@NotNull TFile zipArchive) {
        TFile rootDirectory = new TFile((File)zipArchive, ZIP_BAMBOO_HOME_DIR, DETECTOR);
        return rootDirectory.exists();
    }

    private void dropAndCreateDatabase() throws HibernateException, ConfigurationException {
        log.info((Object)"Deleting current database.");
        this.schemaHelper.dropTables(log.isDebugEnabled());
        log.info((Object)"Database deleted.");
        this.schemaHelper.createTables(log.isDebugEnabled());
        this.cacheManager.flushCaches();
        this.bandanaPersister.flushCaches();
        this.sessionFactory.getCache().evictQueryRegions();
        this.sessionFactory.getCache().evictDefaultQueryRegion();
    }

    private TFile createMapperFile(@NotNull TFile rootDirectory, @NotNull BambooRootMapper mapper) {
        BambooStAXRootMapper staxMapper = (BambooStAXRootMapper)Narrow.to((Object)mapper, BambooStAXRootMapper.class);
        if (staxMapper != null) {
            return new TFile((File)rootDirectory, staxMapper.getXmlRootNodeName() + ".xml", DETECTOR);
        }
        return new TFile((File)rootDirectory, this.asStreamRootMapper(mapper).getFileName(), DETECTOR);
    }

    private TFile getMapperFile(@NotNull TFile zipArchive, @NotNull BambooRootMapper mapper) {
        TFile rootDirectory = new TFile((File)zipArchive, ZIP_DB_EXPORT_DIR, DETECTOR);
        if (!rootDirectory.exists() && !(rootDirectory = new TFile((File)zipArchive, ZIP_CONFIG_DIR, DETECTOR)).exists()) {
            return null;
        }
        BambooStAXRootMapper staxMapper = (BambooStAXRootMapper)Narrow.to((Object)mapper, BambooStAXRootMapper.class);
        if (staxMapper != null) {
            TFile mapperFile = new TFile((File)rootDirectory, staxMapper.getXmlRootNodeName() + ".xml", DETECTOR);
            if (!mapperFile.canRead() && !(mapperFile = new TFile((File)rootDirectory, DB_XML, DETECTOR)).canRead()) {
                return null;
            }
            return mapperFile;
        }
        return new TFile((File)rootDirectory, this.asStreamRootMapper(mapper).getFileName(), DETECTOR);
    }

    @NotNull
    private BambooStreamRootMapper asStreamRootMapper(BambooRootMapper mapper) {
        BambooStreamRootMapper streamMapper = (BambooStreamRootMapper)Narrow.to((Object)mapper, BambooStreamRootMapper.class);
        Preconditions.checkArgument((streamMapper != null ? 1 : 0) != 0, (String)"Unknown mapper class: %s", (Object)mapper.getClass().getName());
        return streamMapper;
    }

    void unzipFolder(String path, String destinationPath, String folderToExtract) throws IOException {
        TFile zipFile = new TFile(path, DETECTOR);
        TFile folderToExtractObject = new TFile((File)zipFile, folderToExtract, DETECTOR);
        if (folderToExtractObject.exists()) {
            TFile dst = new TFile(destinationPath, DETECTOR);
            dst.mkdirs();
            TFile.cp_r((File)folderToExtractObject, (File)dst, (TArchiveDetector)TArchiveDetector.NULL);
        }
    }

    private TFile getAlassianUserFile(@NotNull TFile zipArchive) throws BambooImportException {
        TFile rootDirectory = new TFile((File)zipArchive, ZIP_CONFIG_DIR, DETECTOR);
        if (!rootDirectory.exists()) {
            throw new BambooImportException("Couldn't find configuration directory inside the zip file.");
        }
        TFile inputFile = new TFile((File)rootDirectory, ATLASSIAN_USER_FILE, DETECTOR);
        if (!inputFile.exists()) {
            throw new BambooImportException("Couldn't find atlassian-user.xml inside the zip file.");
        }
        return inputFile;
    }

    private boolean isHibernateRepositoryPresent(@NotNull TFile zipArchive) throws BambooImportException {
        boolean bl;
        TFile inputFile = this.getAlassianUserFile(zipArchive);
        TFileInputStream fis = new TFileInputStream((File)inputFile);
        try {
            XMLConfigurationParser configParser = new XMLConfigurationParser();
            configParser.parse((InputStream)fis);
            bl = configParser.getRepositoryConfigurations().stream().map(RepositoryConfiguration::getIdentifier).anyMatch(HIBERNATE_REPOSITORY_IDENTIFIER::equals);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (com.atlassian.user.configuration.ConfigurationException | IOException e) {
                throw new BambooImportException("Failed to load configuration from atlassian-user.xml", e);
            }
        }
        fis.close();
        return bl;
    }

    public AdministrationConfiguration getAdministrationConfiguration() {
        return this.persister.getAdministrationConfiguration();
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setExporters(List<BambooRootMapper> exporters) {
        this.exporters = exporters;
    }

    public void setHeaderImporters(List<BambooRootMapper> headerImporters) {
        this.headerImporters = headerImporters;
    }

    public void setImporters(List<BambooRootMapper> importers) {
        this.importers = importers;
    }

    public void setOsgiDependentImporters(List<BambooRootMapper> osgiDependentImporters) {
        this.osgiDependentImporters = osgiDependentImporters;
    }

    public void setSchemaHelper(BambooSchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setPersister(Persister persister) {
        this.persister = persister;
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setUpgradeUtilityBean(UpgradeUtilityBean upgradeUtilityBean) {
        this.upgradeUtilityBean = upgradeUtilityBean;
    }

    public void setBandanaPersister(BandanaPersister bandanaPersister) {
        this.bandanaPersister = bandanaPersister;
    }

    public static Set<String> createForeignKeys(Session session, DbmsBean dbmsBean) {
        log.info((Object)"Getting FK constraints...");
        SetMultimap columnsToIndex = MultimapBuilder.treeKeys().hashSetValues().build();
        HashMap<Pair<String, List<String>>, String> constraintNames = new HashMap<Pair<String, List<String>>, String>();
        XmlMigrator.getAllFkConstraints(session, (SetMultimap<String, List<String>>)columnsToIndex, constraintNames, dbmsBean);
        log.info((Object)"Creating indices...");
        HashSet<String> indicesNeeded = new HashSet<String>();
        for (Map.Entry index : columnsToIndex.entries()) {
            try {
                List columns;
                String tableName = (String)index.getKey();
                boolean indexOnColumnsExists = (Boolean)session.doReturningWork(arg_0 -> XmlMigrator.lambda$createForeignKeys$11(dbmsBean, tableName, columns = (List)index.getValue(), arg_0));
                if (indexOnColumnsExists) continue;
                String fkName = constraintNames.get(Pair.of((Object)tableName, (Object)columns));
                String indexName = XmlMigrator.getIndexName(fkName);
                indicesNeeded.add(indexName);
                XmlMigrator.createIndex(session, indexName, tableName, columns, dbmsBean);
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
        return indicesNeeded;
    }

    private static String getIndexName(String fkName) {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)fkName, (CharSequence)"fk")) {
            return fkName;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)fkName, (CharSequence)"fk_ao_")) {
            String newFkName = StringUtils.replaceOnce((String)fkName, (String)"FK_AO_", (String)"FKIX_");
            return StringUtils.replaceOnce((String)newFkName, (String)"fk_ao_", (String)"fkix_");
        }
        String newFkName = StringUtils.replaceOnce((String)fkName, (String)"FK", (String)"FKIX");
        return StringUtils.replaceOnce((String)newFkName, (String)"fk", (String)"fkix");
    }

    private static void getAllFkConstraints(Session session, SetMultimap<String, List<String>> columnsToIndex, HashMap<Pair<String, List<String>>, String> constraintNames, DbmsBean dbmsBean) {
        log.info((Object)"Scanning for FKs that do not have system indices...");
        session.doWork(connection -> {
            List tables = dbmsBean.getTables(connection);
            for (String table : tables) {
                log.info((Object)("Processing table " + table));
                Collection allConstraints = dbmsBean.getConstraints(connection, table, null);
                log.info((Object)("Retrieved constraints of table " + table));
                Set columnsCoveredByAutomaticIndexes = allConstraints.stream().filter(c -> c.isUniqueKey() || c.isPrimaryKey()).map(DbmsBean.ConstraintDefinition::getColumns).map(ArrayList::new).collect(Collectors.toSet());
                Set columnsThatNeedFkIndex = allConstraints.stream().filter(DbmsBean.ConstraintDefinition::isForeignKey).map(DbmsBean.ConstraintDefinition::getColumns).map(ArrayList::new).collect(Collectors.toSet());
                columnsThatNeedFkIndex.removeAll(columnsCoveredByAutomaticIndexes);
                if (!columnsThatNeedFkIndex.isEmpty()) {
                    columnsToIndex.putAll((Object)table, columnsThatNeedFkIndex);
                }
                allConstraints.stream().filter(DbmsBean.ConstraintDefinition::isForeignKey).forEach(c -> constraintNames.put(Pair.of((Object)table, new ArrayList(c.getColumns())), c.getName()));
            }
        });
        log.info((Object)"FKs that need indices retrieved.");
    }

    private static void createIndex(Session session, String indexName, String tableName, List<String> columnList, DbmsBean dbmsBean) {
        String columnListString = Joiner.on((char)',').join(columnList);
        session.doWork(connection -> {
            log.info((Object)("Creating index " + indexName + " on " + tableName + " (" + columnListString + ")"));
            try {
                dbmsBean.createIndex(connection, indexName, tableName, (String)Iterables.getOnlyElement((Iterable)columnList));
            }
            catch (SQLException e) {
                log.warn((Object)("Couldn't create index. If an equivalent index has been manually set up, remove it, it's no longer neeed. Error: " + e));
            }
        });
    }

    private static /* synthetic */ Boolean lambda$createForeignKeys$11(DbmsBean dbmsBean, String tableName, List columns, Connection c) throws SQLException {
        return dbmsBean.hasIndexOnColumns(c, tableName, columns);
    }
}

