/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.beans;

import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.migration.beans.AuthorMigrationCache;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.utils.BambooFunctions;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Map;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AuthorMigrationCacheImpl
implements AuthorMigrationCache {
    private static final Logger log = Logger.getLogger(AuthorMigrationCacheImpl.class);
    private final ResettableLazyReference<Map<Long, ExtendedAuthor>> authorMapRef = new ResettableLazyReference<Map<Long, ExtendedAuthor>>(){

        protected Map<Long, ExtendedAuthor> create() throws Exception {
            return BambooMaps.mutableLinkedUniqueIndex((Iterable)AuthorMigrationCacheImpl.this.authorDao.findAll(), (Function)BambooFunctions.getBambooObjectId());
        }
    };
    private final AuthorDao authorDao;

    public AuthorMigrationCacheImpl(AuthorDao authorDao) {
        this.authorDao = authorDao;
    }

    @Override
    @Nullable
    public ExtendedAuthor get(long authorId) {
        return (ExtendedAuthor)((Map)this.authorMapRef.get()).get(authorId);
    }

    @Override
    public void reset() {
        this.authorMapRef.reset();
    }
}

