/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.beans;

import com.atlassian.bamboo.cluster.state.Stateful;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Stateful
public class DummyResultsSummaryCache {
    private final LoadingCache<PlanResultKey, Optional<Long>> cache;

    public DummyResultsSummaryCache(final @NotNull BuildResultsSummaryDao buildResultsSummaryDao, int cacheSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).softValues().build((CacheLoader)new CacheLoader<PlanResultKey, Optional<Long>>(){

            @Nullable
            public Optional<Long> load(@NotNull PlanResultKey planResultKey) {
                return Optional.fromNullable((Object)buildResultsSummaryDao.getResultsSummaryId(planResultKey));
            }
        });
    }

    @Nullable
    public BuildResultsSummary get(@NotNull PlanResultKey planResultKey) throws ExecutionException {
        Long id = (Long)((Optional)this.cache.get((Object)planResultKey)).orNull();
        if (id == null) {
            return null;
        }
        BuildResultsSummaryImpl brs = new BuildResultsSummaryImpl();
        brs.setId(id.longValue());
        brs.setPlanKey(planResultKey.getPlanKey());
        brs.setBuildNumber(planResultKey.getBuildNumber());
        return brs;
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

