/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.BuildDefinitionMapper;
import com.atlassian.bamboo.migration.stream.LabellingMapper;
import com.atlassian.bamboo.migration.stream.notifications.NotificationSetMapper;
import com.atlassian.bamboo.migration.utils.DeletableInterfaceMapper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.number.PlanBuildNumbersImpl;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractPlanMapper<T extends Plan>
extends BambooStAXMappingListHelperAbstractImpl<T, T> {
    private static final Logger log = Logger.getLogger(AbstractPlanMapper.class);
    static final String PLAN_XML_KEY = "key";
    static final String PLAN_XML_BUILDKEY = "buildKey";
    static final String PLAN_XML_BUILDNAME = "buildName";
    @Deprecated
    static final String PLAN_XML_FIRSTBUILD = "firstBuildNumber";
    @Deprecated
    static final String PLAN_XML_LASTBUILD = "lastBuildNumber";
    @Deprecated
    static final String PLAN_XML_NEXTBUILD = "nextBuildNumber";
    static final String PLAN_XML_SUSPENDED = "suspendedFromBuilding";
    static final String PLAN_XML_DEFINITION = "definition";
    static final String PLAN_XML_MASTER = "master";
    static final String PLAN_XML_DESCRIPTION = "description";
    protected final Project project;
    protected final Map<Long, Label> labelMap;
    protected final Map<Long, ExtendedAuthor> authorMap;
    protected List<Labelling> labels;
    private final BuildDefinitionMapper buildDefinitionMapper;
    protected final NotificationSetMapper notificationSetMapper;
    protected final PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao;
    protected final PlanDao planDao;
    protected final RepositoryDefinitionDao repositoryDefinitionDao;
    protected final PlanRepositoryLinkDao planRepositoryLinkDao;
    protected PlanBuildNumbersImpl planBuildNumbers;

    public AbstractPlanMapper(@NotNull SessionFactory sessionFactory, @NotNull BambooStAXListImportStrategy listImportStrategy, @NotNull Project project, @NotNull Map<Long, Label> labelMap, @NotNull Map<Long, ExtendedAuthor> authorMap, @NotNull PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, @NotNull PlanDao planDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull NotificationSetMapper notificationSetMapper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, listImportStrategy, transactionOperations);
        this.authorMap = authorMap;
        this.project = project;
        this.labelMap = labelMap;
        this.buildDefinitionMapper = new BuildDefinitionMapper(sessionFactory, transactionOperations);
        this.notificationSetMapper = notificationSetMapper;
        this.planVcsRevisionHistoryDao = planVcsRevisionHistoryDao;
        this.planDao = planDao;
        this.repositoryDefinitionDao = repositoryDefinitionDao;
        this.planRepositoryLinkDao = planRepositoryLinkDao;
    }

    public abstract T createPlanEntity();

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull T plan, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, plan, session, exportDetailsBean);
        log.debug((Object)("Exporting plan " + plan.getPlanKey()));
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(PLAN_XML_KEY, plan.getKey()).append(PLAN_XML_BUILDKEY, plan.getBuildKey()).append(PLAN_XML_BUILDNAME, plan.getBuildName()).appendIfNotBlank(PLAN_XML_DESCRIPTION, plan.getDescription()).append(PLAN_XML_SUSPENDED, plan.isSuspendedFromBuilding());
        if (plan.hasMaster()) {
            appender.append(PLAN_XML_MASTER, ((ImmutablePlan)Preconditions.checkNotNull((Object)plan.getMaster(), (Object)"Plan#getMaster() should not be null")).getKey());
        }
        DeletableInterfaceMapper.exportProperties(appender, plan);
        BuildDefinitionForBuild buildDefinitionXml = plan.getBuildDefinitionXml();
        if (buildDefinitionXml != null) {
            this.buildDefinitionMapper.exportXml(session, outputElement, buildDefinitionXml, exportDetailsBean);
        }
        LabellingMapper mapper = new LabellingMapper(this.getSessionFactory(), null, (Plan)plan, this.project, this.labelMap, this.transactionOperations);
        mapper.exportListXml(outputElement, plan.getRelatedLabellings(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull T plan, @NotNull SMInputCursor cursor, @NotNull Session session) throws Exception {
        super.importProperties(plan, cursor, session);
        String elementLocalName = cursor.getLocalName();
        if (PLAN_XML_KEY.equals(elementLocalName)) {
            plan.setKey(cursor.getElemStringValue());
            log.info((Object)("Importing plan " + plan.getKey()));
        } else if (PLAN_XML_BUILDKEY.equals(elementLocalName)) {
            plan.setBuildKey(cursor.getElemStringValue());
        } else if (PLAN_XML_BUILDNAME.equals(elementLocalName)) {
            plan.setBuildName(cursor.getElemStringValue());
        } else if (PLAN_XML_DESCRIPTION.equals(elementLocalName)) {
            plan.setDescription(cursor.getElemStringValue());
        } else if (PLAN_XML_NEXTBUILD.equals(elementLocalName)) {
            if (this.planBuildNumbers == null) {
                this.planBuildNumbers = new PlanBuildNumbersImpl(plan);
            }
            this.planBuildNumbers.setNextBuildNumber(cursor.getElemIntValue());
        } else if (PLAN_XML_SUSPENDED.equals(elementLocalName)) {
            plan.setSuspendedFromBuilding(cursor.getElemBooleanValue());
        } else if (PLAN_XML_MASTER.equals(elementLocalName)) {
            Plan masterPlan = this.planDao.getPlanByKey(cursor.getElemStringValue(), Plan.class);
            plan.setMaster(masterPlan);
        } else if (PLAN_XML_DEFINITION.equals(elementLocalName)) {
            BuildDefinitionForBuild buildDefinitionXml = (BuildDefinitionForBuild)this.buildDefinitionMapper.importXml(session, cursor);
            plan.setBuildDefinitionXml(buildDefinitionXml);
        } else if ("labellings".equals(elementLocalName)) {
            LabellingMapper mapper = new LabellingMapper(this.getSessionFactory(), null, (Plan)plan, this.project, this.labelMap, this.transactionOperations);
            this.labels.addAll(mapper.importListXml(cursor));
        } else if (DeletableInterfaceMapper.isApplicable(elementLocalName)) {
            DeletableInterfaceMapper.importProperties(plan, cursor);
        }
    }

    @Override
    @NotNull
    protected T createItemInstance(SMInputCursor inputCursor) throws Exception {
        T plan = this.createPlanEntity();
        plan.setProject(this.project);
        plan.setDescription("");
        this.labels = new ArrayList<Labelling>();
        this.planBuildNumbers = null;
        return plan;
    }
}

