/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.deletion.Deletable;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.utils.DeletableInterfaceMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryStandaloneDao;
import com.atlassian.bamboo.project.DefaultProject;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.repository.PlanRepositoryLinkDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.utils.BambooFunctions;
import java.util.Map;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractProjectMapper
extends BambooStAXMappingListHelperAbstractImpl<Project, Project>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AbstractProjectMapper.class);
    public static final String PROJECT_XML_ROOT = "projects";
    static final String PROJECT_XML_NODE = "project";
    static final String PROJECT_XML_KEY = "key";
    static final String PROJECT_XML_NAME = "name";
    static final String PROJECT_XML_DESCRIPTION = "description";
    protected Map<Long, ExtendedAuthor> authorMap;
    protected Map<Long, Label> labelMap;
    protected final PlanDao planDao;
    protected final ProjectDao projectDao;
    protected final SessionFactory sessionFactory;
    protected final AuthorDao authorDao;
    protected final LabelDao labelDao;
    protected final PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao;
    protected final RepositoryDefinitionDao repositoryDefinitionDao;
    protected final PlanRepositoryLinkDao planRepositoryLinkDao;

    public AbstractProjectMapper(SessionFactory sessionFactory, @NotNull BambooStAXListImportStrategy listImportStrategy, @NotNull ProjectDao projectDao, AuthorDao authorDao, LabelDao labelDao, @NotNull PlanDao planDao, PlanVcsRevisionHistoryStandaloneDao planVcsRevisionHistoryDao, @NotNull RepositoryDefinitionDao repositoryDefinitionDao, @NotNull PlanRepositoryLinkDao planRepositoryLinkDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, listImportStrategy, transactionOperations);
        this.projectDao = projectDao;
        this.sessionFactory = sessionFactory;
        this.authorDao = authorDao;
        this.labelDao = labelDao;
        this.planDao = planDao;
        this.planVcsRevisionHistoryDao = planVcsRevisionHistoryDao;
        this.repositoryDefinitionDao = repositoryDefinitionDao;
        this.planRepositoryLinkDao = planRepositoryLinkDao;
    }

    protected void initialiseAuthorMap() {
        this.authorMap = BambooMaps.mutableLinkedUniqueIndex((Iterable)this.authorDao.findAll(), (Function)BambooFunctions.getBambooObjectId());
    }

    protected void initialiseLabelMap() {
        this.labelMap = BambooMaps.mutableLinkedUniqueIndex((Iterable)this.labelDao.findAll(), (Function)BambooFunctions.getBambooObjectId());
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return PROJECT_XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return PROJECT_XML_NODE;
    }

    @Override
    protected void importProperties(@NotNull Project project, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(project, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (PROJECT_XML_KEY.equals(elementLocalName)) {
            project.setKey(inputCursor.getElemStringValue());
        } else if (PROJECT_XML_NAME.equals(elementLocalName)) {
            project.setName(inputCursor.getElemStringValue());
        } else if (PROJECT_XML_DESCRIPTION.equals(elementLocalName)) {
            project.setDescription(inputCursor.getElemStringValue());
        } else if (DeletableInterfaceMapper.isApplicable(elementLocalName)) {
            DeletableInterfaceMapper.importProperties((Deletable)project, inputCursor);
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Project project, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, project, session, exportDetailsBean);
        log.info((Object)("Exporting project [" + project.getName() + "]"));
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(PROJECT_XML_KEY, project.getKey()).append(PROJECT_XML_NAME, project.getName()).appendIfNotBlank(PROJECT_XML_DESCRIPTION, project.getDescription());
        DeletableInterfaceMapper.exportProperties(appender, (Deletable)project);
    }

    @Override
    @NotNull
    protected Project createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new DefaultProject();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.initialiseAuthorMap();
        this.initialiseLabelMap();
        this.exportListXml(outputElement, this.projectDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.initialiseAuthorMap();
        this.initialiseLabelMap();
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
    }
}

