/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.BuildResultWarningSummaryMapper;
import com.atlassian.bamboo.migration.stream.CustomBuildDataMapper;
import com.atlassian.bamboo.migration.stream.LabellingMapper;
import com.atlassian.bamboo.migration.stream.LinkedJiraIssuesMapper;
import com.atlassian.bamboo.migration.stream.VariableContextSnapshotMapper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.MutableTestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummary;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.VariableContextSnapshot;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineImpl;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public abstract class AbstractResultSummaryMapper<T extends ResultsSummary>
extends BambooStAXMappingListHelperAbstractImpl<T, T> {
    private static final Logger log = Logger.getLogger(AbstractResultSummaryMapper.class);
    private static final String BUILDSUMMARY_XML_BUILDNUMBER = "buildNumber";
    private static final String BUILDSUMMARY_XML_BUILDDATE = "buildDate";
    private static final String BUILDSUMMARY_XML_BUILDCOMPLETEDDATE = "buildCompletedDate";
    private static final String BUILDSUMMARY_XML_QUEUE_TIME = "queueTime";
    private static final String BUILDSUMMARY_XML_BUILDSTATE = "buildState";
    private static final String BUILDSUMMARY_XML_LIFECYCLESTATE = "lifeCycleState";
    private static final String BUILDSUMMARY_XML_DURATION = "duration";
    private static final String BUILDSUMMARY_XML_PROCESSING_DURATION = "processingDuration";
    private static final String BUILDSUMMARY_XML_TRIGGERREASON = "buildReason";
    private static final String BUILDSUMMARY_XML_DELTASTATE = "deltaState";
    private static final String BUILDSUMMARY_XML_LABELS = "labellings";
    private static final String BUILDSUMMARY_XML_LINKEDJIRAISSUES = "linkedjiraIssues";
    private static final String BUILDSUMMARY_XML_RESTART_COUNT = "restartCount";
    protected static final String BUILDSUMMARY_XML_MARKED_FOR_DELETION = "markedForDeletion";
    private static final String BUILDSUMMARY_XML_ONCE_OFF = "onceOff";
    private static final String BUILDSUMMARY_XML_CUSTOM_BUILD = "customBuild";
    private static final String BUILDSUMMARY_XML_REBUILD = "rebuild";
    private static final String TESTSUMMARY_XML_TOTAL_COUNT = "totalTestCount";
    private static final String TESTSUMMARY_XML_SUCCESS_COUNT = "successTestCount";
    private static final String TESTSUMMARY_XML_FAILED_COUNT = "failedTestCount";
    private static final String TESTSUMMARY_XML_BROKEN_COUNT = "brokenTestCount";
    private static final String TESTSUMMARY_XML_EXISTING_COUNT = "existingTestCount";
    private static final String TESTSUMMARY_XML_FIXED_COUNT = "fixedTestCount";
    private static final String TESTSUMMARY_XML_TOTAL_DURATION = "totalDuration";
    private static final String TESTSUMMARY_XML_QUARANTINED_COUNT = "quarantinedTestCount";
    private static final String TESTSUMMARY_XML_SKIPPED_COUNT = "skippedTestCount";
    private static final String BUILDSUMMARY_XML_FORMAT_VERSION = "formatVersion";
    private static final String BUILDSUMMARY_XML_VARIABLE_BASELINE_ID = "variableContextBaselineId";
    private static final String BUILDSUMMARY_XML_CANCELLED_DATE = "cancelledDate";
    private static final String BUILDSUMMARY_XML_TIME_TO_FIX = "timeToFix";
    private static final String BUILDSUMMARY_XML_LOG_SIZE = "logSize";
    private static final String BUILDSUMMARY_XML_PLAN_NAME = "planName";
    private static final String BUILDSUMMARY_XML_PLAN_KEY = "planKey";
    private static final Set<String> LEGACY_NOT_BUILD_BUILDSTATE = ImmutableSet.of((Object)"Not Built", (Object)"Pending", (Object)"NotBuilt");
    protected final Plan buildable;
    protected final Project project;
    protected final Map<Long, Label> labelMap;
    private final List<Labelling> labels;
    private final List<BuildResultWarningSummary> warningSummaries;
    protected final BuildResultsSummaryDao buildResultsSummaryDao;
    protected final VariableContextBaselineDao variableContextBaselineDao;
    private final CustomBuildDataMapper customBuildDataMapper;
    private final LinkedJiraIssuesMapper linkedJiraIssueMapper;
    private final VariableContextSnapshotMapper variableContextSnapshotMapper;
    protected final BuildResultWarningSummaryMapper buildResultWarningSummaryMapper;
    private static final Map<String, String> reasonMappings = new HashMap<String, String>(){
        {
            this.put("Initial clean build", "com.atlassian.bamboo.plugin.system.triggerReason:InitialBuildTriggerReason");
            this.put("Code has changed", "com.atlassian.bamboo.plugin.system.triggerReason:CodeChangedTriggerReason");
            this.put("Manual build", "com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason");
            this.put("Dependency build", "com.atlassian.bamboo.plugin.system.triggerReason:DependencyTriggerReason");
            this.put("Project edited", "com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason");
            this.put("Scheduled build", "com.atlassian.bamboo.plugin.system.triggerReason:ScheduledTriggerReason");
            this.put("Rerun build", "com.atlassian.bamboo.plugin.system.triggerReason:RerunBuildTriggerReason");
        }
    };

    public AbstractResultSummaryMapper(SessionFactory sessionFactory, BuildResultsSummaryDao buildResultsSummaryDao, VariableContextBaselineDao variableContextBaselineDao, BuildResultWarningSummaryMapper buildResultWarningSummaryMapper, Plan buildable, Project project, Map<Long, Label> labelMap, TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.buildResultsSummaryDao = buildResultsSummaryDao;
        this.variableContextBaselineDao = variableContextBaselineDao;
        this.buildResultWarningSummaryMapper = buildResultWarningSummaryMapper;
        this.buildable = buildable;
        this.project = project;
        this.labelMap = labelMap;
        this.customBuildDataMapper = new CustomBuildDataMapper(sessionFactory, transactionOperations);
        this.linkedJiraIssueMapper = new LinkedJiraIssuesMapper(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
        this.variableContextSnapshotMapper = new VariableContextSnapshotMapper(sessionFactory, transactionOperations);
        this.labels = new ArrayList<Labelling>();
        this.warningSummaries = new ArrayList<BuildResultWarningSummary>();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull T buildResultsSummary, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        AbstractResultsSummary brs;
        VariableContextBaseline variableContextBaseline;
        if (!exportDetailsBean.isExportResults()) {
            log.info((Object)("isExportResults is false. Not exporting " + buildResultsSummary.getPlanResultKey()));
            return;
        }
        super.exportProperties(outputElement, buildResultsSummary, session, exportDetailsBean);
        TestResultsSummary testResultSummary = buildResultsSummary.getTestResultsSummary();
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement).append(BUILDSUMMARY_XML_BUILDNUMBER, buildResultsSummary.getBuildNumber()).appendIfNotNull(BUILDSUMMARY_XML_BUILDDATE, buildResultsSummary.getBuildDate()).appendIfNotNull(BUILDSUMMARY_XML_BUILDCOMPLETEDDATE, buildResultsSummary.getBuildCompletedDate()).appendIfNotNull(BUILDSUMMARY_XML_QUEUE_TIME, buildResultsSummary.getQueueTime()).appendIfNotNull(BUILDSUMMARY_XML_CANCELLED_DATE, buildResultsSummary.getBuildCancelledDate()).append(BUILDSUMMARY_XML_BUILDSTATE, buildResultsSummary.getBuildState().toString()).append(BUILDSUMMARY_XML_LIFECYCLESTATE, buildResultsSummary.getLifeCycleState().getValue()).append(BUILDSUMMARY_XML_DURATION, buildResultsSummary.getDuration()).append(BUILDSUMMARY_XML_PROCESSING_DURATION, buildResultsSummary.getProcessingDuration()).append(BUILDSUMMARY_XML_RESTART_COUNT, buildResultsSummary.getRestartCount()).append(BUILDSUMMARY_XML_ONCE_OFF, buildResultsSummary.isOnceOff()).append(BUILDSUMMARY_XML_CUSTOM_BUILD, buildResultsSummary.isCustomBuild()).append(BUILDSUMMARY_XML_REBUILD, buildResultsSummary.isRebuild()).append(TESTSUMMARY_XML_TOTAL_COUNT, testResultSummary.getTotalTestCaseCount()).append(TESTSUMMARY_XML_SUCCESS_COUNT, testResultSummary.getSuccessfulTestCaseCount()).append(TESTSUMMARY_XML_FAILED_COUNT, testResultSummary.getFailedTestCaseCount()).append(TESTSUMMARY_XML_BROKEN_COUNT, testResultSummary.getNewFailedTestCaseCount()).append(TESTSUMMARY_XML_EXISTING_COUNT, testResultSummary.getExistingFailedTestCount()).append(TESTSUMMARY_XML_FIXED_COUNT, testResultSummary.getFixedTestCaseCount()).append(TESTSUMMARY_XML_QUARANTINED_COUNT, testResultSummary.getQuarantinedTestCaseCount()).append(TESTSUMMARY_XML_TOTAL_DURATION, testResultSummary.getTotalTestDuration()).append(TESTSUMMARY_XML_SKIPPED_COUNT, testResultSummary.getSkippedTestCaseCount()).append(BUILDSUMMARY_XML_FORMAT_VERSION, buildResultsSummary.getFormatVersion()).appendIfNotNull(BUILDSUMMARY_XML_TIME_TO_FIX, buildResultsSummary.getTimeToFix()).appendIfNotNull(BUILDSUMMARY_XML_LOG_SIZE, buildResultsSummary.getLogSize()).append(BUILDSUMMARY_XML_PLAN_NAME, buildResultsSummary.getPlanName()).append(BUILDSUMMARY_XML_PLAN_KEY, buildResultsSummary.getPlanKey().getKey());
        Long variableContextBaselineId = buildResultsSummary.getVariableContextBaselineId();
        if (variableContextBaselineId != null && (variableContextBaseline = this.variableContextBaselineDao.getVariableContextBaseline(variableContextBaselineId.longValue())) != null) {
            appender.append(BUILDSUMMARY_XML_VARIABLE_BASELINE_ID, variableContextBaseline.getId());
        }
        if ((brs = (AbstractResultsSummary)Narrow.reinterpret(buildResultsSummary, AbstractResultsSummary.class)) != null) {
            appender.appendIfNotBlank(BUILDSUMMARY_XML_TRIGGERREASON, brs.getTriggerReasonKey());
        }
        appender.appendIfNotNull(BUILDSUMMARY_XML_DELTASTATE, buildResultsSummary.getDeltaState());
        LabellingMapper mapper = new LabellingMapper(this.getSessionFactory(), (ResultsSummary)buildResultsSummary, this.buildable, this.project, this.labelMap, this.transactionOperations);
        mapper.exportListXml(outputElement, buildResultsSummary.getLabellings(), exportDetailsBean);
        this.customBuildDataMapper.exportMapXml(outputElement, buildResultsSummary.getCustomBuildData(), exportDetailsBean);
        this.variableContextSnapshotMapper.exportListXml(outputElement, buildResultsSummary.getVariableContextLogsEncrypted(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull T buildResultSummary, @NotNull SMInputCursor cursor, @NotNull Session session) throws Exception {
        String elementLocalName = cursor.getLocalName();
        super.importProperties(buildResultSummary, cursor, session);
        if (cursor.getCurrEvent() != SMEvent.START_ELEMENT) {
            return;
        }
        AbstractResultsSummary buildResultSummaryImpl = (AbstractResultsSummary)buildResultSummary;
        switch (elementLocalName) {
            case "buildNumber": {
                buildResultSummaryImpl.setBuildNumber(cursor.getElemIntValue());
                break;
            }
            case "buildDate": {
                buildResultSummaryImpl.setBuildDate(MapperUtil.parseDateElement(cursor.getElemStringValue()));
                break;
            }
            case "buildCompletedDate": {
                buildResultSummaryImpl.setBuildCompletedDate(MapperUtil.parseDateElement(cursor.getElemStringValue()));
                break;
            }
            case "queueTime": {
                buildResultSummaryImpl.setQueueTime(MapperUtil.parseDateElement(cursor.getElemStringValue()));
                break;
            }
            case "cancelledDate": {
                buildResultSummaryImpl.setBuildCancelledDate(MapperUtil.parseDateElement(cursor.getElemStringValue()));
                break;
            }
            case "buildState": {
                String buildStateString = cursor.getElemStringValue();
                if (LEGACY_NOT_BUILD_BUILDSTATE.contains(buildStateString)) {
                    buildResultSummaryImpl.setBuildState(BuildState.UNKNOWN);
                    break;
                }
                buildResultSummaryImpl.setBuildState(BuildState.getInstance((String)buildStateString));
                break;
            }
            case "lifeCycleState": {
                buildResultSummaryImpl.setLifeCycleState(LifeCycleState.getInstance((String)cursor.getElemStringValue()));
                break;
            }
            case "duration": {
                buildResultSummaryImpl.setDuration(cursor.getElemLongValue());
                break;
            }
            case "processingDuration": {
                buildResultSummaryImpl.setProcessingDuration(cursor.getElemLongValue());
                break;
            }
            case "restartCount": {
                buildResultSummaryImpl.setRestartCount(cursor.getElemIntValue());
                break;
            }
            case "buildReason": {
                String triggerReasonKey = cursor.getElemStringValue();
                triggerReasonKey = this.convertFromReasonForBuildIfNecessary(triggerReasonKey);
                buildResultSummaryImpl.setTriggerReasonKey(triggerReasonKey);
                break;
            }
            case "deltaState": {
                buildResultSummaryImpl.setDeltaState((DeltaState)cursor.getElemEnumValue(DeltaState.class));
                break;
            }
            case "onceOff": {
                buildResultSummaryImpl.setOnceOff(cursor.getElemBooleanValue());
                break;
            }
            case "customBuild": {
                buildResultSummaryImpl.setCustomBuild(cursor.getElemBooleanValue());
                break;
            }
            case "rebuild": {
                buildResultSummaryImpl.setRebuild(cursor.getElemBooleanValue());
                break;
            }
            case "labellings": {
                LabellingMapper mapper = new LabellingMapper(this.getSessionFactory(), (ResultsSummary)buildResultSummary, this.buildable, this.project, this.labelMap, this.transactionOperations);
                this.labels.addAll(mapper.importListXml(cursor));
                break;
            }
            case "variableContextLogs": {
                List variableContextLogs = this.variableContextSnapshotMapper.importListXml(cursor);
                for (VariableContextSnapshot variableContextLog : variableContextLogs) {
                    variableContextLog.setResultSummary((ResultsSummary)buildResultSummaryImpl);
                }
                buildResultSummary.getVariableContextLogsEncrypted().addAll(variableContextLogs);
                break;
            }
            case "warnings": {
                List warnings = this.buildResultWarningSummaryMapper.importListXml(cursor);
                for (BuildResultWarningSummary warningSummary : warnings) {
                    ((BuildResultWarningSummaryImpl)warningSummary).setResultSummary((ImmutableResultsSummary)buildResultSummaryImpl);
                }
                this.warningSummaries.addAll(warnings);
                break;
            }
            case "formatVersion": {
                ((AbstractResultsSummary)buildResultSummary).setFormatVersion(cursor.getElemIntValue());
                break;
            }
            case "variableContextBaselineId": {
                ((AbstractResultsSummary)buildResultSummary).setVariableContextBaseline((VariableContextBaseline)MapperUtil.createFakeObject(VariableContextBaselineImpl.class, cursor));
                break;
            }
            case "timeToFix": {
                buildResultSummary.setTimeToFix(Long.valueOf(cursor.getElemLongValue()));
                break;
            }
            case "logSize": {
                buildResultSummary.setLogSize(Long.valueOf(cursor.getElemLongValue()));
                break;
            }
            case "planName": {
                ((AbstractResultsSummary)buildResultSummary).setPlanName(cursor.getElemStringValue());
                break;
            }
            case "planKey": {
                ((AbstractResultsSummary)buildResultSummary).setPlanKey(PlanKeys.getPlanKey((String)cursor.getElemStringValue()));
            }
            default: {
                if (!MapperUtil.matchesElement(this.customBuildDataMapper, elementLocalName)) break;
                buildResultSummaryImpl.setCustomBuildData(this.customBuildDataMapper.importMapXml(cursor));
            }
        }
        this.importJiraIssues(buildResultSummary, cursor, elementLocalName);
        this.importTestResultsSummaryProperties((MutableTestResultsSummary)buildResultSummary.getTestResultsSummary(), cursor, elementLocalName);
    }

    private void importJiraIssues(@NotNull T buildResultSummary, @NotNull SMInputCursor cursor, @NotNull String elementLocalName) throws Exception {
        if (BUILDSUMMARY_XML_LINKEDJIRAISSUES.equals(elementLocalName)) {
            List issues = this.linkedJiraIssueMapper.importListXml(cursor);
            for (LinkedJiraIssue issue : issues) {
                issue.setResultsSummary(buildResultSummary);
            }
            buildResultSummary.getJiraIssues().addAll(issues);
        }
    }

    private void importTestResultsSummaryProperties(@NotNull MutableTestResultsSummary testResultsSummary, @NotNull SMInputCursor cursor, @NotNull String elementLocalName) throws Exception {
        switch (elementLocalName) {
            case "totalTestCount": {
                testResultsSummary.setTotalTestCaseCount(cursor.getElemIntValue());
                break;
            }
            case "successTestCount": {
                testResultsSummary.setSuccessfulTestCaseCount(cursor.getElemIntValue());
                break;
            }
            case "failedTestCount": {
                testResultsSummary.setFailedTestCaseCount(cursor.getElemIntValue());
                break;
            }
            case "brokenTestCount": {
                testResultsSummary.setNewFailedTestCaseCount(cursor.getElemIntValue());
                break;
            }
            case "existingTestCount": {
                testResultsSummary.setExistingFailedTestCount(cursor.getElemIntValue());
                break;
            }
            case "fixedTestCount": {
                testResultsSummary.setFixedTestCaseCount(cursor.getElemIntValue());
                break;
            }
            case "totalDuration": {
                testResultsSummary.setTotalTestDuration(cursor.getElemLongValue());
                break;
            }
            case "quarantinedTestCount": {
                testResultsSummary.setQuarantinedTestCaseCount(cursor.getElemIntValue());
                break;
            }
            case "skippedTestCount": {
                testResultsSummary.setSkippedTestCaseCount(cursor.getElemIntValue());
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<T> list, @NotNull T buildResultsSummary, long objectIndex, @NotNull Session session) throws Exception {
        if (buildResultsSummary.getLifeCycleState() == null) {
            if (buildResultsSummary.getBuildState() == BuildState.UNKNOWN) {
                buildResultsSummary.updateLifeCycleState(LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
            } else {
                buildResultsSummary.updateLifeCycleState(LifeCycleState.FINISHED, buildResultsSummary.getBuildState());
            }
        }
        for (ArtifactLink artifact : buildResultsSummary.getArtifactLinks()) {
            if (artifact.getArtifact().getId() >= 0L) continue;
            session.save((Object)artifact.getArtifact());
        }
        session.replicate(buildResultsSummary, ReplicationMode.OVERWRITE);
        for (BuildResultWarningSummary warningSummary : this.warningSummaries) {
            this.saveBambooObject(session, (BambooIdProvider)warningSummary);
        }
        this.warningSummaries.clear();
        for (ArtifactLink artifact : buildResultsSummary.getArtifactLinks()) {
            session.replicate((Object)artifact, ReplicationMode.OVERWRITE);
        }
    }

    private String convertFromReasonForBuildIfNecessary(String triggerReasonKey) {
        if (reasonMappings.containsValue(triggerReasonKey)) {
            return triggerReasonKey;
        }
        return reasonMappings.getOrDefault(triggerReasonKey, null);
    }

    public List<Labelling> getLabels() {
        return this.labels;
    }
}

