/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.AceBean;
import com.atlassian.bamboo.migration.stream.AceMapper;
import com.atlassian.bamboo.security.acegi.acls.AclDao;
import com.atlassian.bamboo.security.acegi.acls.AlwaysGrantAclAuthorizationStrategy;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.domain.AclAuthorizationStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class AclMapper
extends BambooStAXMappingListHelperAbstractImpl<Acl, Acl>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AclMapper.class);
    static final String ACL_XML_ROOT = "acls";
    static final String ACL_XML_NODE = "acl";
    static final String ACL_XML_OBJECTID = "objectIdentity";
    static final String ACL_XML_OBJECTYPE = "objectType";
    static final String ACL_XML_OWNER = "owner";
    static final String ACL_XML_OWNER_TYPE = "ownerType";
    private final AclDao aclDao;
    private final BambooAclUpdateHelper aclUpdateHelper;
    private long objectId;
    private String objectType;
    private String owner;
    private String ownerType;
    private List<AceBean> aces;
    private AceMapper aceMapper;

    protected AclMapper(SessionFactory sessionFactory, AclDao aclDao, BambooAclUpdateHelper aclUpdateHelper, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.aclDao = aclDao;
        this.aclUpdateHelper = aclUpdateHelper;
        this.aceMapper = new AceMapper(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return ACL_XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return ACL_XML_ROOT;
    }

    @Override
    @NotNull
    protected Acl createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new HibernateAclImpl();
    }

    @Override
    public void beforeImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<Acl> acls, @NotNull Session session) throws Exception {
        this.objectId = 0L;
        this.objectType = null;
        this.owner = null;
        this.ownerType = null;
        this.aces = new ArrayList<AceBean>();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<Acl> acls, @NotNull Acl object, long objectIndex, @NotNull Session session) throws Exception {
        Sid ownerSid = this.getSidFromIdAndType(this.owner, this.ownerType);
        HibernateObjectIdentityImpl id = new HibernateObjectIdentityImpl(this.objectType, (Serializable)Long.valueOf(this.objectId));
        HibernateAclImpl acl = new HibernateAclImpl((ObjectIdentity)id, null, true, ownerSid);
        acl.setAclAuthorizationStrategy((AclAuthorizationStrategy)new AlwaysGrantAclAuthorizationStrategy());
        for (AceBean ace : this.aces) {
            Sid aceSid = this.getSidFromIdAndType(ace.getSid(), ace.getSidType());
            acl.insertAce(null, BambooPermission.buildFromMask((int)ace.getMask()), aceSid, true);
        }
        this.aclDao.save((Acl)acl);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Acl object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElementAppender appender = new SMOutputElementAppender(outputElement);
        appender.append(ACL_XML_OBJECTID, object.getObjectIdentity().getIdentifier().toString()).append(ACL_XML_OBJECTYPE, object.getObjectIdentity().getJavaType().getName());
        Sid owner = object.getOwner();
        if (owner instanceof GroupPrincipalSid) {
            GroupPrincipalSid groupSid = (GroupPrincipalSid)owner;
            appender.append(ACL_XML_OWNER, groupSid.getPrincipal());
            appender.append(ACL_XML_OWNER_TYPE, "GROUP_PRINCIPAL");
        } else if (owner instanceof GrantedAuthoritySid) {
            GrantedAuthoritySid authSid = (GrantedAuthoritySid)owner;
            appender.append(ACL_XML_OWNER, authSid.getGrantedAuthority());
            appender.append(ACL_XML_OWNER_TYPE, "GRANTED_AUTHORITY");
        } else {
            PrincipalSid principalSid = (PrincipalSid)owner;
            appender.append(ACL_XML_OWNER, principalSid.getPrincipal());
            appender.append(ACL_XML_OWNER_TYPE, "PRINCIPAL");
        }
        AccessControlEntry[] aces = object.getEntries();
        ArrayList<AceBean> acesList = new ArrayList<AceBean>();
        for (AccessControlEntry ace : aces) {
            String type;
            String sid;
            Sid aceSid = ace.getSid();
            if (aceSid instanceof PrincipalSid) {
                PrincipalSid principalSid = (PrincipalSid)aceSid;
                sid = principalSid.getPrincipal();
                type = "PRINCIPAL";
            } else if (aceSid instanceof GroupPrincipalSid) {
                GroupPrincipalSid groupPrincipalSid = (GroupPrincipalSid)aceSid;
                sid = groupPrincipalSid.getPrincipal();
                type = "GROUP_PRINCIPAL";
            } else if (aceSid instanceof GrantedAuthoritySid) {
                GrantedAuthoritySid authSid = (GrantedAuthoritySid)aceSid;
                sid = authSid.getGrantedAuthority();
                type = "GRANTED_AUTHORITY";
            } else {
                log.warn((Object)("Unknown type of SID found: " + aceSid.getClass().getName() + ", ignoring"));
                continue;
            }
            acesList.add(new AceBean(ace.getPermission().getMask(), sid, type));
        }
        this.aceMapper.exportListXml(outputElement, acesList, exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull Acl object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (ACL_XML_OBJECTID.equals(elementLocalName)) {
            this.objectId = inputCursor.getElemLongValue();
        } else if (ACL_XML_OBJECTYPE.equals(elementLocalName)) {
            this.objectType = inputCursor.getElemStringValue();
        } else if (ACL_XML_OWNER.equals(elementLocalName)) {
            this.owner = inputCursor.getElemStringValue();
        } else if (ACL_XML_OWNER_TYPE.equals(elementLocalName)) {
            this.ownerType = inputCursor.getElemStringValue();
        } else if ("aces".equals(elementLocalName)) {
            this.aces = this.aceMapper.importListXml(inputCursor);
        }
    }

    @Nullable
    private Sid getSidFromIdAndType(String id, String type) {
        try {
            return this.aclUpdateHelper.getSidFromIdAndType(id, type);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)String.format("Could not construct ACL sid (id=%s, type=%s), reason: %s", id, type, e.getMessage()));
            return null;
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.aclDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
        this.getSession().clear();
    }
}

