/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.migration.stream.generic.StringListMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="artifactDefinitions", itemNodeName="definition")
public class ArtifactDefinitionMapper
extends BambooStAXMappingListHelperAbstractImpl<ArtifactDefinition, ArtifactDefinition>
implements BambooStAXRootMapper {
    static final String NAME = "name";
    static final String LOCATION = "location";
    static final String COPY_PATTERN = "copyPattern";
    static final String COPY_PATTERNS = "copyPatterns";
    static final String EXCLUSION_PATTERNS = "exclusionPatterns";
    static final String SHARED_ARTIFACT = "sharedArtifact";
    static final String REQUIRED_ARTIFACT = "required";
    static final String HTTP_COMPRESSION_ON_ARTIFACT = "httpCompressionOn";
    static final String PRODUCER_JOB = "producerJob";
    private final ArtifactDefinitionDao artifactDefinitionDao;
    private final PlanDao planDao;
    private Map<PlanKey, Long> jobsKeysToIds;
    private final StringListMapper copyPatternsMapper;
    private final StringListMapper exclusionPatternsMapper;

    public ArtifactDefinitionMapper(SessionFactory sessionFactory, ArtifactDefinitionDao artifactDefinitionDao, PlanDao planDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.artifactDefinitionDao = artifactDefinitionDao;
        this.planDao = planDao;
        this.copyPatternsMapper = new StringListMapper(sessionFactory, COPY_PATTERNS, transactionOperations);
        this.exclusionPatternsMapper = new StringListMapper(sessionFactory, EXCLUSION_PATTERNS, transactionOperations);
    }

    @Override
    @NotNull
    protected ArtifactDefinition createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new ArtifactDefinitionImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ArtifactDefinition object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(NAME, object.getName()).appendIfNotBlank(LOCATION, object.getLocation()).append(SHARED_ARTIFACT, object.isSharedArtifact()).append(REQUIRED_ARTIFACT, object.isRequired()).append(HTTP_COMPRESSION_ON_ARTIFACT, object.isHttpCompressionOn()).append(PRODUCER_JOB, object.getProducerJob().getKey());
        this.copyPatternsMapper.exportListXml(session, outputElement, object.getCopyPatterns(), exportDetailsBean);
        this.exclusionPatternsMapper.exportListXml(session, outputElement, object.getExclusionPatterns(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull ArtifactDefinition object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (NAME.equals(elementLocalName)) {
            object.setName(inputCursor.getElemStringValue());
        } else if (LOCATION.equals(elementLocalName)) {
            object.setLocation(inputCursor.getElemStringValue());
        } else if (COPY_PATTERN.equals(elementLocalName)) {
            object.setCopyPatterns(Collections.singletonList(inputCursor.getElemStringValue()));
        } else if (COPY_PATTERNS.equals(elementLocalName)) {
            object.setCopyPatterns(this.copyPatternsMapper.importListXml(session, inputCursor));
        } else if (EXCLUSION_PATTERNS.equals(elementLocalName)) {
            object.setExclusionPatterns(this.exclusionPatternsMapper.importListXml(session, inputCursor));
        } else if (SHARED_ARTIFACT.equals(elementLocalName)) {
            object.setSharedArtifact(inputCursor.getElemBooleanValue());
        } else if (REQUIRED_ARTIFACT.equals(elementLocalName)) {
            object.setRequired(inputCursor.getElemBooleanValue());
        } else if (HTTP_COMPRESSION_ON_ARTIFACT.equals(elementLocalName)) {
            object.setHttpCompressionOn(inputCursor.getElemBooleanValue());
        } else if (PRODUCER_JOB.equals(elementLocalName)) {
            PlanKey planKey = PlanKeys.getPlanKey((String)inputCursor.getElemStringValue());
            Long producerJobId = this.jobsKeysToIds.get(planKey);
            if (producerJobId == null) {
                throw new BambooImportException(String.format("No job with key: %s", planKey), inputCursor);
            }
            DefaultJob producerJob = new DefaultJob();
            producerJob.setId(producerJobId.longValue());
            object.setProducerJob((Job)producerJob);
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ArtifactDefinition> artifactDefinitions, @NotNull ArtifactDefinition object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.artifactDefinitionDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.jobsKeysToIds = this.planDao.getPlanKeysPlanIdsMapping(DefaultJob.class);
        this.importListXml(inputCursor);
        this.jobsKeysToIds.clear();
    }
}

