/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.migration.stream.ArtifactDefinitionMapper;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionDao;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ArtifactSubscriptionMapper
extends BambooStAXMappingListHelperAbstractImpl<ArtifactSubscription, ArtifactSubscription>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ArtifactDefinitionMapper.class);
    static final String XML_ROOT = "artifactSubscriptions";
    static final String XML_NODE = "subscription";
    static final String DEFINITION = "definition";
    static final String DESTINATION_DIRECTORY = "destinationDirectory";
    static final String CONSUMER_JOB = "consumerJob";
    private final ArtifactDefinitionDao artifactDefinitionDao;
    private final ArtifactSubscriptionDao artifactSubscriptionDao;
    private final PlanDao planDao;
    private Map<PlanKey, Long> jobsKeysToIds;

    public ArtifactSubscriptionMapper(SessionFactory sessionFactory, ArtifactDefinitionDao artifactDefinitionDao, ArtifactSubscriptionDao artifactSubscriptionDao, PlanDao planDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.artifactDefinitionDao = artifactDefinitionDao;
        this.artifactSubscriptionDao = artifactSubscriptionDao;
        this.planDao = planDao;
    }

    @Override
    @NotNull
    protected ArtifactSubscription createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new ArtifactSubscriptionImpl();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ArtifactSubscription object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(DEFINITION, object.getArtifactDefinition().getId()).appendIfNotBlank(DESTINATION_DIRECTORY, object.getDestinationDirectory()).append(CONSUMER_JOB, object.getConsumerJob().getKey());
    }

    @Override
    protected void importProperties(@NotNull ArtifactSubscription object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (DEFINITION.equals(elementLocalName)) {
            long id = inputCursor.getElemLongValue();
            ArtifactDefinitionImpl artifactDefinition = new ArtifactDefinitionImpl();
            artifactDefinition.setId(id);
            object.setArtifactDefinition((ArtifactDefinition)artifactDefinition);
        } else if (DESTINATION_DIRECTORY.equals(elementLocalName)) {
            object.setDestinationDirectory(inputCursor.getElemStringValue());
        } else if (CONSUMER_JOB.equals(elementLocalName)) {
            PlanKey planKey = PlanKeys.getPlanKey((String)inputCursor.getElemStringValue());
            Long producerJobId = this.jobsKeysToIds.get(planKey);
            if (producerJobId == null) {
                throw new BambooImportException(String.format("No job with key: %s", planKey), inputCursor);
            }
            DefaultJob consumerJob = new DefaultJob();
            consumerJob.setId(producerJobId.longValue());
            object.setConsumerJob((Job)consumerJob);
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ArtifactSubscription> artifactDefinitions, @NotNull ArtifactSubscription object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.artifactSubscriptionDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.jobsKeysToIds = this.planDao.getPlanKeysPlanIdsMapping(DefaultJob.class);
        this.importListXml(inputCursor);
        this.jobsKeysToIds.clear();
    }
}

