/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.persister.AuditLogDao;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.persister.AuditLogMessage;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.util.Narrow;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class AuditLogMapper
extends BambooStAXMappingListHelperAbstractImpl<AuditLogEntry, AuditLogEntry>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(AuditLogMapper.class);
    static final String XML_ROOT = "auditLogs";
    static final String XML_NODE = "auditLog";
    static final String XML_TIMESTAMP = "timestamp";
    static final String XML_MESSAGE_TYPE = "messageType";
    static final String XML_MESSAGE = "message";
    static final String XML_OLD_VALUE = "oldValue";
    static final String XML_NEW_VALUE = "newValue";
    static final String XML_PLAN_KEY = "planKey";
    static final String XML_ENTITY_ID = "entityId";
    static final String XML_JOB_KEY = "jobKey";
    static final String XML_CHILD_ID = "childId";
    static final String XML_USER_NAME = "userName";
    static final String XML_TASK_HEADER = "taskHeader";
    static final String XML_ENTITY_TYPE = "entityType";
    static final String XML_ENTITY_HEADER = "entityHeader";
    static final String XML_FIELD_HEADER = "fieldHeader";
    static final String XML_FIELD_TYPE = "fieldType";
    private final AuditLogDao auditLogDao;

    public AuditLogMapper(SessionFactory sessionFactory, AuditLogDao auditLogDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.auditLogDao = auditLogDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<AuditLogEntry> auditLogEntries, @NotNull AuditLogEntry object, long objectIndex, @NotNull Session session) throws Exception {
        AuditLogMessageForImport objectForImport = (AuditLogMessageForImport)((Object)Narrow.downTo((Object)object, AuditLogMessageForImport.class));
        IdParts idParts = new IdParts(objectForImport);
        String entityId = idParts.getEntityId();
        String childId = idParts.getChildId();
        AuditLogMessage message = new AuditLogMessage(object.getUsername(), new Date(object.getTimestamp()), idParts.getEntityType(), entityId, childId, this.calculateField(object, idParts.getEntityType()), object.getMessageType(), object.getMessage(), object.getOldValue(), object.getNewValue());
        message.setId(object.getId());
        this.saveBambooObject(session, (BambooIdProvider)message);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull AuditLogEntry object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        SMOutputElementAppender sMOutputElementAppender = new SMOutputElementAppender(outputElement).append(XML_TIMESTAMP, object.getTimestamp()).append(XML_MESSAGE_TYPE, object.getMessageType()).append(XML_MESSAGE, object.getMessage()).appendIfNotBlank(XML_OLD_VALUE, object.getOldValue()).appendIfNotBlank(XML_NEW_VALUE, object.getNewValue()).appendIfNotBlank(XML_ENTITY_ID, object.getEntityId()).appendIfNotBlank(XML_CHILD_ID, object.getChildId()).appendIfNotNull(XML_FIELD_TYPE, object.getFieldType()).appendIfNotBlank(XML_USER_NAME, object.getUsername()).appendIfNotBlank(XML_FIELD_HEADER, object.getFieldHeader());
        if (object.getEntityType() != null) {
            sMOutputElementAppender.append(XML_ENTITY_TYPE, object.getEntityType().toString());
        }
    }

    @Override
    protected void importProperties(@NotNull AuditLogEntry object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        super.importProperties(object, inputCursor, session);
        AuditLogMessageForImport auditLogMessage = (AuditLogMessageForImport)((Object)Narrow.to((Object)object, AuditLogMessageForImport.class));
        if (auditLogMessage != null) {
            if (XML_TIMESTAMP.equals(elementLocalName)) {
                auditLogMessage.setTimestamp(inputCursor.getElemLongValue());
            } else if (XML_MESSAGE_TYPE.equals(elementLocalName)) {
                auditLogMessage.setMessageType(inputCursor.getElemStringValue());
            } else if (XML_MESSAGE.equals(elementLocalName)) {
                auditLogMessage.setMessage(inputCursor.getElemStringValue());
            } else if (XML_OLD_VALUE.equals(elementLocalName)) {
                auditLogMessage.setOldValue(inputCursor.getElemStringValue());
            } else if (XML_NEW_VALUE.equals(elementLocalName)) {
                auditLogMessage.setNewValue(inputCursor.getElemStringValue());
            } else if (XML_PLAN_KEY.equals(elementLocalName)) {
                auditLogMessage.setPlanKey(inputCursor.getElemStringValue());
            } else if (XML_ENTITY_ID.equals(elementLocalName)) {
                auditLogMessage.setEntityId(inputCursor.getElemStringValue());
            } else if (XML_JOB_KEY.equals(elementLocalName)) {
                auditLogMessage.setJobKey(inputCursor.getElemStringValue());
            } else if (XML_CHILD_ID.equals(elementLocalName)) {
                auditLogMessage.setChildId(inputCursor.getElemStringValue());
            } else if (XML_USER_NAME.equals(elementLocalName)) {
                auditLogMessage.setUsername(inputCursor.getElemStringValue());
            } else if (XML_ENTITY_HEADER.equals(elementLocalName) || XML_FIELD_HEADER.equals(elementLocalName)) {
                auditLogMessage.setFieldHeader(inputCursor.getElemStringValue());
            } else if (XML_FIELD_TYPE.equals(elementLocalName)) {
                auditLogMessage.setFieldType(AuditLogEntityType.getInstance((String)inputCursor.getElemStringValue()));
            } else if (XML_ENTITY_TYPE.equals(elementLocalName)) {
                auditLogMessage.setEntityType(AuditLogEntityType.getInstance((String)inputCursor.getElemStringValue()));
            } else if (XML_TASK_HEADER.equals(elementLocalName)) {
                auditLogMessage.setFieldHeader(inputCursor.getElemStringValue());
                auditLogMessage.setEntityType(AuditLogEntityType.TASK);
            }
        }
    }

    @Override
    @NotNull
    protected AuditLogMessageForImport createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new AuditLogMessageForImport();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.auditLogDao.scrollAuditLogsForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }

    @Nullable
    private AuditLogEntity calculateField(@NotNull AuditLogEntry object, AuditLogEntityType entityType) {
        AuditLogEntity field = object.getFieldType() == null ? (object.getEntityType() != null && !object.getEntityType().equals((Object)entityType) ? new AuditLogEntity(object.getEntityType(), StringUtils.defaultString((String)object.getFieldHeader())) : null) : new AuditLogEntity(object.getFieldType(), StringUtils.defaultString((String)object.getFieldHeader()));
        return field;
    }

    private class AuditLogMessageForImport
    extends AuditLogMessage {
        private String planKey;
        private String jobKey;

        private AuditLogMessageForImport() {
        }

        public String getPlanKey() {
            return this.planKey;
        }

        public void setPlanKey(String planKey) {
            this.planKey = planKey;
        }

        public String getJobKey() {
            return this.jobKey;
        }

        public void setJobKey(String jobKey) {
            this.jobKey = jobKey;
        }

        protected void setTimestamp(Long timestamp) {
            super.setTimestamp(timestamp);
        }

        protected void setMessageType(String messageType) {
            super.setMessageType(messageType);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }

        protected void setNewValue(String newValue) {
            super.setNewValue(newValue);
        }

        protected void setOldValue(String oldValue) {
            super.setOldValue(oldValue);
        }

        protected void setUsername(String username) {
            super.setUsername(username);
        }

        protected void setFieldHeader(String fieldHeader) {
            super.setFieldHeader(fieldHeader);
        }

        protected void setEntityType(AuditLogEntityType auditLogEntityType) {
            super.setEntityType(auditLogEntityType);
        }
    }

    private final class IdParts {
        private String entityId;
        private String childId;
        private AuditLogEntityType entityType;

        private IdParts(AuditLogMessageForImport auditLogRecord) {
            this.initParts(auditLogRecord);
        }

        String getEntityId() {
            return this.entityId;
        }

        String getChildId() {
            return this.childId;
        }

        AuditLogEntityType getEntityType() {
            return this.entityType;
        }

        private void initParts(AuditLogMessageForImport objectForImport) {
            if (objectForImport.getEntityId() == null) {
                String key = StringUtils.defaultString((String)objectForImport.getJobKey(), (String)objectForImport.getPlanKey());
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    if (PlanKeys.isPlanKey((String)key)) {
                        this.entityType = AuditLogEntityType.PLAN;
                        PlanKey chainKeyIfJobKey = PlanKeys.getChainKeyIfJobKey((PlanKey)PlanKeys.getPlanKey((String)key));
                        if (chainKeyIfJobKey == null) {
                            this.entityId = key;
                            this.childId = null;
                        } else {
                            this.entityId = chainKeyIfJobKey.getKey();
                            this.childId = key;
                        }
                    } else {
                        this.entityType = AuditLogEntityType.DEPLOYMENT_PROJECT;
                        if (objectForImport.getPlanKey().contains("-")) {
                            String[] parts = objectForImport.getPlanKey().split("-");
                            this.entityId = parts[0];
                            this.childId = parts[1];
                        } else {
                            this.entityId = objectForImport.getPlanKey();
                            this.childId = null;
                        }
                    }
                } else {
                    this.entityType = null;
                    this.entityId = null;
                    this.childId = null;
                }
            } else {
                this.entityId = objectForImport.getEntityId();
                this.childId = objectForImport.getChildId();
                this.entityType = objectForImport.getEntityType();
            }
        }
    }
}

