/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.AuthorDataImpl;
import com.atlassian.bamboo.author.AuthorDuplicateNameHelper;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="authors", itemNodeName="author")
public class AuthorMapper
extends BambooStAXMappingListHelperAbstractImpl<Author, Author>
implements BambooStAXRootMapper {
    static final String AUTHOR_XML_NAME = "name";
    static final String AUTHOR_XML_EMAIL = "email";
    static final String AUTHOR_XML_LINKED_USER = "linkedUser";
    private final AuthorDao authorDao;

    public AuthorMapper(SessionFactory sessionFactory, AuthorDao authorDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.authorDao = authorDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<Author> authorList, @NotNull Author author, long objectIndex, @NotNull Session session) throws Exception {
        int authorIndex = authorList.indexOf(author);
        if (authorIndex >= 0) {
            AuthorDataImpl originalAuthor = (AuthorDataImpl)authorList.get(authorIndex);
            AuthorDataImpl duplicateAuthor = (AuthorDataImpl)author;
            duplicateAuthor.setName(AuthorDuplicateNameHelper.createNameMarkerPattern((long)originalAuthor.getId(), (long)duplicateAuthor.getId()));
        }
        authorList.add(author);
        this.saveBambooObject(session, (BambooIdProvider)((BambooObject)author));
    }

    @Override
    @NotNull
    protected Author createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return new AuthorImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Author object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotBlank(AUTHOR_XML_NAME, object.getName()).appendIfNotBlank(AUTHOR_XML_EMAIL, object.getEmail()).appendIfNotBlank(AUTHOR_XML_LINKED_USER, object.getLinkedUserName());
    }

    @Override
    protected void importProperties(@NotNull Author object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (AUTHOR_XML_NAME.equals(elementLocalName)) {
            ((AuthorImpl)object).setName(inputCursor.getElemStringValue());
        } else if (AUTHOR_XML_EMAIL.equals(elementLocalName)) {
            object.setEmail(inputCursor.getElemStringValue());
        } else if (AUTHOR_XML_LINKED_USER.equals(elementLocalName)) {
            object.setLinkedUserName(inputCursor.getElemStringValue());
        }
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.authorDao.findAll(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

