/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.bandana.BandanaItem;
import com.atlassian.bamboo.bandana.BandanaItemDao;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class BandanaItemMapper
extends BambooStAXMappingListHelperAbstractImpl<BandanaItem, BandanaItem>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(BandanaItemMapper.class);
    static final String BANDANA_ITEM_XML_ROOT = "bandanaItems";
    static final String BANDANA_ITEM_XML_NODE = "bandanaItem";
    static final String BANDANA_ITEM_BUILD_ID = "buildId";
    static final String BANDANA_ITEM_CHAIN_ID = "chainId";
    static final String BANDANA_ITEM_KEY = "key";
    static final String BANDANA_ITEM_SERIALIZED_DATA = "serializedData";
    private static final int FLUSH_SIZE = 100;
    private final BandanaItemDao bandanaItemDao;

    protected BandanaItemMapper(SessionFactory sessionFactory, BandanaItemDao bandanaItemDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.bandanaItemDao = bandanaItemDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<BandanaItem> bandanaItems, @NotNull BandanaItem object, long objectIndex, @NotNull Session session) throws Exception {
        this.bandanaItemDao.save(object);
        this.flushIfNeeded(session, objectIndex, 100L);
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BandanaItem object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        new SMOutputElementAppender(outputElement).append(BANDANA_ITEM_BUILD_ID, object.getBuildId()).append(BANDANA_ITEM_CHAIN_ID, object.getChainId()).append(BANDANA_ITEM_KEY, object.getKey()).append(BANDANA_ITEM_SERIALIZED_DATA, object.getSerializedData());
    }

    @Override
    protected void importProperties(@NotNull BandanaItem object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (BANDANA_ITEM_BUILD_ID.equals(elementLocalName)) {
            object.setBuildId(inputCursor.getElemLongValue());
        } else if (BANDANA_ITEM_CHAIN_ID.equals(elementLocalName)) {
            object.setChainId(inputCursor.getElemLongValue());
        } else if (BANDANA_ITEM_KEY.equals(elementLocalName)) {
            object.setKey(inputCursor.getElemStringValue());
        }
        if (BANDANA_ITEM_SERIALIZED_DATA.equals(elementLocalName)) {
            object.setSerializedData(inputCursor.getElemStringValue());
        }
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return BANDANA_ITEM_XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return BANDANA_ITEM_XML_ROOT;
    }

    @Override
    @NotNull
    protected BandanaItem createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new BandanaItem();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportListXml(outputElement, this.bandanaItemDao.getAllBandanaItems(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }
}

