/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class BuildDefinitionMapper
extends BambooStAXMappingHelperAbstractImpl<BuildDefinitionForBuild, BuildDefinitionForBuild> {
    private static final Logger log = Logger.getLogger(BuildDefinitionMapper.class);
    static final String BUILD_XML_DEFINITION = "definition";
    static final String BUILD_XML_DEFINITION_XML = "xml";

    protected BuildDefinitionMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return BUILD_XML_DEFINITION;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BuildDefinitionForBuild object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendCData(BUILD_XML_DEFINITION_XML, object.getXmlData());
    }

    @Override
    protected void importProperties(@NotNull BuildDefinitionForBuild object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (BUILD_XML_DEFINITION_XML.equals(elementLocalName)) {
            object.setXmlData(inputCursor.getElemStringValue());
        }
    }

    @Override
    @NotNull
    protected BuildDefinitionForBuild createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new DefaultBuildDefinitionForBuild(false);
    }
}

