/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXMappingHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.config.ApplicationConfiguration;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class BuildNumberMapper
extends BambooStAXMappingHelperAbstractImpl<String, String>
implements BambooStAXRootMapper {
    private static final String ELEMENT_BUILD_NUMBER = "build";
    private final ApplicationConfiguration applicationConfiguration;

    public BuildNumberMapper(SessionFactory sessionFactory, ApplicationConfiguration applicationConfiguration, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return ELEMENT_BUILD_NUMBER;
    }

    @Override
    @NotNull
    protected String createItemInstance(@NotNull SMInputCursor inputCursor) throws Exception {
        return inputCursor.getElemStringValue();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull String object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        outputElement.addCharacters(object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        this.exportXml(outputElement, this.applicationConfiguration.getBuildNumber(), exportDetailsBean);
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.applicationConfiguration.setBuildNumber((String)this.importXml(inputCursor));
    }
}

