/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.AbstractResultSummaryMapper;
import com.atlassian.bamboo.migration.stream.BuildResultWarningSummaryMapper;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="buildResultSummaries", itemNodeName="buildResultSummary")
public class BuildResultSummaryMapper
extends AbstractResultSummaryMapper<BuildResultsSummary> {
    private static final Logger log = Logger.getLogger(BuildResultSummaryMapper.class);
    public static final String XML_ROOT = "buildResultSummaries";
    private static final String BUILDSUMMARY_XML_AGENTID = "agentId";
    private static final String BUILDSUMMARY_XML_AGENTTYPE = "agentType";
    private static final String BUILDSUMMARY_XML_VCS_UPDATE_TIME = "vcsUpdateTime";
    private final Plan plan;
    @Nullable
    private ChainResultsSummary chainResultsSummary;
    @Nullable
    private Long stageResultId;

    public BuildResultSummaryMapper(SessionFactory sessionFactory, BuildResultsSummaryDao buildResultsSummaryDao, VariableContextBaselineDao variableContextBaselineDao, BuildResultWarningSummaryMapper buildResultWarningSummaryMapper, Plan plan, Project project, Map<Long, Label> labelMap, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, buildResultsSummaryDao, variableContextBaselineDao, buildResultWarningSummaryMapper, plan, project, labelMap, transactionOperations);
        this.plan = plan;
    }

    public BuildResultSummaryMapper(SessionFactory sessionFactory, BuildResultsSummaryDao buildResultsSummaryDao, VariableContextBaselineDao variableContextBaselineDao, BuildResultWarningSummaryMapper warningSummaryMapper, Project project, Map<Long, Label> labelMap, TransactionOperations transactionOperations, ChainResultsSummary chainResult, long stageResultId) {
        this(sessionFactory, buildResultsSummaryDao, variableContextBaselineDao, warningSummaryMapper, null, project, labelMap, transactionOperations);
        this.chainResultsSummary = chainResult;
        this.stageResultId = stageResultId;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull BuildResultsSummary buildResultsSummary, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        if (!exportDetailsBean.isExportResults()) {
            log.info((Object)("isExportResults is false. Not exporting " + buildResultsSummary.getPlanResultKey()));
            return;
        }
        super.exportProperties(outputElement, buildResultsSummary, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).appendIfNotNull(BUILDSUMMARY_XML_AGENTID, buildResultsSummary.getBuildAgentId()).appendIfNotNull(BUILDSUMMARY_XML_AGENTTYPE, buildResultsSummary.getBuildAgentType()).appendIfNotNull(BUILDSUMMARY_XML_VCS_UPDATE_TIME, buildResultsSummary.getVcsUpdateTime()).append("markedForDeletion", buildResultsSummary.isMarkedForDeletion());
    }

    @Override
    protected void importProperties(@NotNull BuildResultsSummary buildResultSummary, @NotNull SMInputCursor cursor, @NotNull Session session) throws Exception {
        String elementLocalName = cursor.getLocalName();
        super.importProperties(buildResultSummary, cursor, session);
        BuildResultsSummaryImpl buildResultSummaryImpl = (BuildResultsSummaryImpl)buildResultSummary;
        if (BUILDSUMMARY_XML_AGENTID.equals(elementLocalName)) {
            buildResultSummaryImpl.setBuildAgentId(cursor.getElemLongValue());
        } else if (BUILDSUMMARY_XML_AGENTTYPE.equals(elementLocalName)) {
            buildResultSummaryImpl.setBuildAgentType((AgentType)cursor.getElemEnumValue(AgentType.class));
        } else if ("markedForDeletion".equals(elementLocalName)) {
            buildResultSummaryImpl.setMarkedForDeletion(cursor.getElemBooleanValue(false));
        } else if (BUILDSUMMARY_XML_VCS_UPDATE_TIME.equals(elementLocalName)) {
            buildResultSummaryImpl.setVcsUpdateTime(MapperUtil.parseDateElement(cursor.getElemStringValue()));
        }
    }

    @Override
    @NotNull
    protected BuildResultsSummary createItemInstance(SMInputCursor inputCursor) throws Exception {
        BuildResultsSummaryImpl buildResultSummary = new BuildResultsSummaryImpl();
        if (this.plan != null) {
            buildResultSummary.setBuildKey(this.plan.getKey());
        } else if (this.chainResultsSummary != null) {
            buildResultSummary.setChainResultsSummary(this.chainResultsSummary);
            buildResultSummary.setStageResultId(this.stageResultId);
        }
        String agentStr = inputCursor.getAttrValue(BUILDSUMMARY_XML_AGENTID);
        if (agentStr != null) {
            buildResultSummary.setBuildAgentId(Long.parseLong(agentStr));
        }
        buildResultSummary.setFormatVersion(1);
        return buildResultSummary;
    }
}

