/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class CapabilitySetMapper
extends BambooStAXMappingListHelperAbstractImpl<Capability, Capability> {
    static final String XML_ROOT = "capabilities";
    static final String XML_NODE = "capability";
    static final String ATTRIBUTE_KEY = "key";
    static final String ATTRIBUTE_VALUE = "value";
    static final String ATTRIBUTE_SOURCE = "source";

    protected CapabilitySetMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.NO_TRANSACTION, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    protected Capability createItemInstance(SMInputCursor inputCursor) throws Exception {
        String key = inputCursor.getAttrValue(ATTRIBUTE_KEY);
        String value = inputCursor.getAttrValue(ATTRIBUTE_VALUE);
        CapabilitySource capabilitySource = Optional.ofNullable(inputCursor.getAttrValue(ATTRIBUTE_SOURCE)).map(Integer::valueOf).flatMap(capabilitySourceMask -> Arrays.stream(CapabilitySource.values()).filter(source -> source.getMask() == capabilitySourceMask.intValue()).findFirst()).orElse(null);
        return new CapabilityImpl(key, value, capabilitySource);
    }

    @Override
    public <E extends Capability> void exportListXml(@NotNull Session session, @NotNull SMOutputElement outputElement, @NotNull Iterable<E> list, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = outputElement.addElement(this.getXmlRootNodeName());
        for (Capability capability : list) {
            SMOutputElement newCapability = rootElement.addElement(this.getXmlElementNodeName());
            newCapability.addAttribute(ATTRIBUTE_KEY, capability.getKey());
            String value = capability.getValue();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                newCapability.addAttribute(ATTRIBUTE_VALUE, capability.getValueWithDefault());
            }
            if (capability.getCapabilitySource() == null) continue;
            newCapability.addAttribute(ATTRIBUTE_SOURCE, String.valueOf(capability.getCapabilitySource().getMask()));
        }
    }
}

