/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentImpl;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class CommentMapper
extends BambooStAXMappingListHelperAbstractImpl<Comment, Comment> {
    private static final Logger log = Logger.getLogger(CommentMapper.class);
    public static final String COMMENTS_XML_ROOT = "comments";
    private static final String COMMENTS_XML_NODE = "comment";
    private static final String COMMENTS_XML_CONTENT = "content";
    private static final String COMMENTS_XML_USER = "user";
    private static final String COMMENTS_XML_ENTITY_ID = "entityId";

    public CommentMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    public CommentMapper(SessionFactory sessionFactory, @NotNull BambooStAXListImportStrategy listImportStrategy, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, listImportStrategy, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return COMMENTS_XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return COMMENTS_XML_NODE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Comment object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(COMMENTS_XML_USER, object.getUserName()).appendIfNotBlank(COMMENTS_XML_CONTENT, object.getContent()).append(COMMENTS_XML_ENTITY_ID, object.getEntityId());
    }

    @Override
    protected void importProperties(@NotNull Comment comment, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(comment, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (COMMENTS_XML_CONTENT.equals(elementLocalName)) {
            comment.setContent(inputCursor.getElemStringValue());
        } else if (COMMENTS_XML_USER.equals(elementLocalName)) {
            comment.setUserName(inputCursor.getElemStringValue());
        } else if (COMMENTS_XML_ENTITY_ID.equals(elementLocalName)) {
            comment.setEntityId(inputCursor.getElemLongValue());
        }
    }

    @Override
    @NotNull
    protected Comment createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new CommentImpl();
    }
}

