/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentDao;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.stream.CommentMapper;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import java.util.List;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class CommentRootMapper
extends CommentMapper
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(CommentRootMapper.class);
    private final CommentDao commentDao;

    public CommentRootMapper(SessionFactory sessionFactory, @NotNull CommentDao commentDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, transactionOperations);
        this.commentDao = commentDao;
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<Comment> list, @NotNull Comment object, long objectIndex, @NotNull Session session) throws Exception {
        this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.commentDao.scrollCommentsForExport((Consumer)new Consumer<Comment>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable Comment comment) {
                if (comment != null) {
                    try {
                        CommentRootMapper.this.exportXml(rootElement, comment, exportDetailsBean);
                        ++this.index;
                        if (this.index % 10000L == 0L) {
                            log.info((Object)String.format("Exporting Comment: %d", this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + comment), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

