/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class CommitFilesMapper
extends BambooStAXMappingListHelperAbstractImpl<CommitFile, CommitFile> {
    private static final Logger log = Logger.getLogger(CommitFilesMapper.class);
    private static final String XML_ROOT = "files";
    private static final String XML_NODE = "file";
    private static final String XML_COMMIT_FILE_NAME = "name";
    private static final String XML_COMMIT_FILE_REVISION = "revision";

    protected CommitFilesMapper(SessionFactory sessionFactory, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    protected CommitFile createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new CommitFileImpl();
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull CommitFile file, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        new SMOutputElementAppender(outputElement).append(XML_COMMIT_FILE_NAME, file.getName()).appendIfNotBlank(XML_COMMIT_FILE_REVISION, file.getRevision());
    }

    @Override
    protected void importProperties(@NotNull CommitFile object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        if (object instanceof CommitFileImpl) {
            CommitFileImpl commitFile = (CommitFileImpl)object;
            String elementLocalName = inputCursor.getLocalName();
            if (XML_COMMIT_FILE_NAME.equals(elementLocalName)) {
                commitFile.setName(inputCursor.getElemStringValue());
            } else if (XML_COMMIT_FILE_REVISION.equals(elementLocalName)) {
                commitFile.setRevision(inputCursor.getElemStringValue());
            }
        }
    }
}

