/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.CommitFilesMapper;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class CommitMapper
extends BambooStAXMappingListHelperAbstractImpl<Commit, Commit> {
    private static final Logger log = Logger.getLogger(CommitMapper.class);
    public static final String COMMITS_XML_ROOT = "commits";
    static final String COMMITS_XML_NODE = "commit";
    static final String COMMITS_XML_AUTHOR = "author";
    static final String COMMITS_XML_REVISION = "revision";
    static final String COMMITS_XML_DATE = "date";
    static final String COMMITS_XML_FILES = "files";
    static final String COMMITS_XML_COMMENT = "commits";
    static final String COMMITS_XML_IS_FOREIGN = "foreignCommit";
    protected Map<Long, ExtendedAuthor> authorMap;
    protected final CommitFilesMapper commitFilesMapper;

    public CommitMapper(SessionFactory sessionFactory, @NotNull BambooStAXListImportStrategy listImportStrategy, @NotNull Map<Long, ExtendedAuthor> authorMap, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, listImportStrategy, transactionOperations);
        this.authorMap = authorMap;
        this.commitFilesMapper = new CommitFilesMapper(sessionFactory, transactionOperations);
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return "commits";
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return COMMITS_XML_NODE;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Commit commit, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, commit, session, exportDetailsBean);
        Author author = commit.getAuthor();
        if (author instanceof ExtendedAuthor) {
            outputElement.addElement(COMMITS_XML_AUTHOR).addCharacters(Long.toString(((BambooIdProvider)author).getId()));
        }
        new SMOutputElementAppender(outputElement).append("commits", commit.getComment()).appendIfNotNull(COMMITS_XML_DATE, commit.getDate()).appendIfNotBlank(COMMITS_XML_REVISION, commit.getChangeSetId()).append(COMMITS_XML_IS_FOREIGN, commit.isForeignCommit());
        this.commitFilesMapper.exportListXml(outputElement, commit.getFiles(), exportDetailsBean);
    }

    @Override
    protected void importProperties(@NotNull Commit commit, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(commit, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (COMMITS_XML_AUTHOR.equals(elementLocalName)) {
            Author author;
            long authorId = inputCursor.getElemLongValue();
            if (this.authorMap != null && (author = (Author)this.authorMap.get(authorId)) != null) {
                commit.setAuthor(author);
            }
        } else if ("commits".equals(elementLocalName)) {
            ((CommitImpl)commit).setComment(inputCursor.getElemStringValue());
        } else if (COMMITS_XML_DATE.equals(elementLocalName)) {
            ((CommitImpl)commit).setDate(MapperUtil.parseDateElement(inputCursor.getElemStringValue()));
        } else if (COMMITS_XML_REVISION.equals(elementLocalName)) {
            ((CommitImpl)commit).setChangeSetId(inputCursor.getElemStringValue());
        } else if (COMMITS_XML_FILES.equals(elementLocalName)) {
            commit.setFiles(this.commitFilesMapper.importListXml(inputCursor));
        } else if (COMMITS_XML_IS_FOREIGN.equals(elementLocalName)) {
            commit.setForeignCommit(inputCursor.getElemBooleanValue());
        }
    }

    @Override
    @NotNull
    protected Commit createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new CommitImpl();
    }
}

