/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitDao;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.stream.CommitMapper;
import com.atlassian.bamboo.migration.stream.MapperExportException;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetDao;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.utils.BambooFunctions;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionOperations;

public class CommitRootMapper
extends CommitMapper
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(CommitRootMapper.class);
    static final String XML_REPOSITORY_CHANGESET_ID = "repositoryChangesetId";
    private final AuthorDao authorDao;
    private final CommitDao commitDao;
    private final RepositoryChangesetDao repositoryChangesetDao;

    public CommitRootMapper(SessionFactory sessionFactory, @NotNull AuthorDao authorDao, @NotNull CommitDao commitDao, @Nullable RepositoryChangesetDao repositoryChangesetDao, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_10000_ITEMS_TRANSACTION, Collections.emptyMap(), transactionOperations);
        this.authorDao = authorDao;
        this.commitDao = commitDao;
        this.repositoryChangesetDao = repositoryChangesetDao;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<Commit> list, @NotNull Commit object, long objectIndex, @NotNull Session session) throws Exception {
        if (object.getRepositoryChangeset() != null) {
            this.eventEndElementOfListItemSaveObject(session, object, objectIndex, 50L);
        }
    }

    @Override
    protected void importProperties(@NotNull Commit commit, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName = inputCursor.getLocalName();
        if (XML_REPOSITORY_CHANGESET_ID.equals(elementLocalName)) {
            RepositoryChangesetImpl repositoryChangeset = new RepositoryChangesetImpl();
            repositoryChangeset.setId(inputCursor.getElemLongValue());
            commit.setRepositoryChangeset((RepositoryChangeset)repositoryChangeset);
        } else {
            super.importProperties(commit, inputCursor, session);
        }
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull Commit commit, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        RepositoryChangeset repositoryChangeset = commit.getRepositoryChangeset();
        if (repositoryChangeset != null) {
            new SMOutputElementAppender(outputElement).append(XML_REPOSITORY_CHANGESET_ID, repositoryChangeset.getId());
        }
        super.exportProperties(outputElement, commit, session, exportDetailsBean);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, final ExportDetailsBean exportDetailsBean) throws Exception {
        final SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.commitDao.scrollCommitsForExport((Consumer)new Consumer<Commit>(){
            private long index = 0L;

            @Override
            public void accept(@Nullable Commit commit) {
                if (commit != null) {
                    try {
                        CommitRootMapper.this.exportXml(rootElement, commit, exportDetailsBean);
                        ++this.index;
                        if (this.index % 10000L == 0L) {
                            log.info((Object)String.format("Exporting Commit: %d", this.index));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not export " + commit), (Throwable)e);
                        throw new MapperExportException(e);
                    }
                }
            }
        });
    }

    protected void initialiseAuthorMap() {
        this.authorMap = BambooMaps.mutableLinkedUniqueIndex((Iterable)this.authorDao.findAll(), (Function)BambooFunctions.getBambooObjectId());
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        Session session = this.getSession();
        this.initialiseAuthorMap();
        this.importListXml(session, inputCursor);
        session.clear();
    }
}

