/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDao;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXListImportStrategy;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.migration.beans.DummyResultsSummaryCache;
import com.atlassian.bamboo.migration.exception.BambooImportException;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscriptionDao;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscriptionImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

public class ConsumedSubscriptionMapper
extends BambooStAXMappingListHelperAbstractImpl<ConsumedSubscription, ConsumedSubscription>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(ConsumedSubscriptionMapper.class);
    static final String XML_ROOT = "consumedSubscriptions";
    static final String XML_NODE = "subscription";
    static final String ARTIFACT_LINK = "artifactLink";
    static final String DESTINATION_DIRECTORY = "destinationDirectory";
    static final String CONSUMER_JOB_RESULT = "consumerJobResult";
    private final ConsumedSubscriptionDao consumedSubscriptionDao;
    private final ArtifactLinkDao artifactLinkDao;
    private final DummyResultsSummaryCache dummyResultsSummaryCache;

    public ConsumedSubscriptionMapper(SessionFactory sessionFactory, ConsumedSubscriptionDao consumedSubscriptionDao, ArtifactLinkDao artifactLinkDao, DummyResultsSummaryCache dummyResultsSummaryCache, @NotNull TransactionOperations transactionOperations) {
        super(sessionFactory, BambooStAXListImportStrategy.LIST_TRANSACTION, transactionOperations);
        this.consumedSubscriptionDao = consumedSubscriptionDao;
        this.artifactLinkDao = artifactLinkDao;
        this.dummyResultsSummaryCache = dummyResultsSummaryCache;
    }

    @Override
    public boolean isShouldExport(@NotNull ExportDetailsBean exportDetailsBean) {
        return exportDetailsBean.isExportResults();
    }

    @Override
    @NotNull
    protected ConsumedSubscription createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new ConsumedSubscriptionImpl();
    }

    @Override
    @NotNull
    public String getXmlElementNodeName() {
        return XML_NODE;
    }

    @Override
    @NotNull
    public String getXmlRootNodeName() {
        return XML_ROOT;
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull ConsumedSubscription object, @NotNull Session session, ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(ARTIFACT_LINK, object.getArtifactLink().getId()).appendIfNotBlank(DESTINATION_DIRECTORY, object.getDestinationDirectory()).append(CONSUMER_JOB_RESULT, object.getConsumerResultSummary().getPlanResultKey().getKey());
    }

    @Override
    protected void importProperties(@NotNull ConsumedSubscription object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        super.importProperties(object, inputCursor, session);
        String elementLocalName = inputCursor.getLocalName();
        if (ARTIFACT_LINK.equals(elementLocalName)) {
            Long id = inputCursor.getElemLongValue();
            ArtifactLink artifactLink = (ArtifactLink)this.artifactLinkDao.findById(id.longValue());
            if (artifactLink == null) {
                throw new BambooImportException(String.format("Cannot find ArtifactLink [%d]", id), inputCursor);
            }
            object.setArtifactLink(artifactLink);
        } else if (DESTINATION_DIRECTORY.equals(elementLocalName)) {
            object.setDestinationDirectory(inputCursor.getElemStringValue());
        } else if (CONSUMER_JOB_RESULT.equals(elementLocalName)) {
            PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)inputCursor.getElemStringValue());
            BuildResultsSummary resultsSummary = this.dummyResultsSummaryCache.get(planResultKey);
            if (resultsSummary == null) {
                throw new BambooImportException(String.format("Cannot find ResultSummary [%s]", planResultKey.getKey()), inputCursor);
            }
            object.setConsumerResultSummary((ResultsSummary)resultsSummary);
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor inputCursor, @NotNull List<ConsumedSubscription> subscriptions, @NotNull ConsumedSubscription object, long objectIndex, @NotNull Session session) throws Exception {
        this.saveBambooObject(session, (BambooIdProvider)object);
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.consumedSubscriptionDao.scrollConsumedSubscriptionsForExport(MapperUtil.exportXmlConsumer(this, rootElement, exportDetailsBean));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXml(inputCursor);
    }
}

