/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.migration.stream;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.migration.BambooStAXMappingListHelperAbstractImpl;
import com.atlassian.bamboo.migration.BambooStAXRootMapper;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ListMapper;
import com.atlassian.bamboo.migration.MapperUtil;
import com.atlassian.bamboo.migration.SMOutputElementAppender;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntity;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityDao;
import com.atlassian.bamboo.user.cleanup.CrowdDeletedEntityImpl;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.out.SMOutputElement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionOperations;

@ListMapper(rootNodeName="crowdDeletedEntities", itemNodeName="crowdDeletedEntity")
public class CrowdDeletedEntityMapper
extends BambooStAXMappingListHelperAbstractImpl<CrowdDeletedEntity, CrowdDeletedEntity>
implements BambooStAXRootMapper {
    private static final Logger log = Logger.getLogger(CrowdDeletedEntityMapper.class);
    private static final String CDE_XML_ENTITY_TYPE = "entityType";
    private static final String CDE_XML_ENTITY_NAME = "entityName";
    private static final String CDE_XML_DELETION_DATE = "deletionDate";
    private final CrowdDeletedEntityDao crowdDeletedEntityDao;

    protected CrowdDeletedEntityMapper(SessionFactory sessionFactory, TransactionOperations transactionOperations, CrowdDeletedEntityDao crowdDeletedEntityDao) {
        super(sessionFactory, transactionOperations);
        this.crowdDeletedEntityDao = crowdDeletedEntityDao;
    }

    @Override
    @NotNull
    protected CrowdDeletedEntity createItemInstance(SMInputCursor inputCursor) throws Exception {
        return new CrowdDeletedEntityImpl();
    }

    @Override
    public void exportData(@NotNull SMOutputElement outputElement, ExportDetailsBean exportDetailsBean) throws Exception {
        SMOutputElement rootElement = this.createListRootElement(outputElement);
        this.crowdDeletedEntityDao.scrollAll(element -> this.exportXml(rootElement, element, exportDetailsBean));
    }

    @Override
    protected void exportProperties(@NotNull SMOutputElement outputElement, @NotNull CrowdDeletedEntity object, @NotNull Session session, @NotNull ExportDetailsBean exportDetailsBean) throws Exception {
        super.exportProperties(outputElement, object, session, exportDetailsBean);
        new SMOutputElementAppender(outputElement).append(CDE_XML_ENTITY_TYPE, object.getEntityType().name()).append(CDE_XML_ENTITY_NAME, object.getEntityName()).append(CDE_XML_DELETION_DATE, BambooDateUtils.dateToPortableString((Date)object.getDeletionDate()));
    }

    @Override
    public void importData(@NotNull SMInputCursor inputCursor) throws Exception {
        this.importListXmlInTransaction(inputCursor);
    }

    @Override
    protected void importProperties(@NotNull CrowdDeletedEntity object, @NotNull SMInputCursor inputCursor, @NotNull Session session) throws Exception {
        String elementLocalName;
        super.importProperties(object, inputCursor, session);
        switch (elementLocalName = inputCursor.getLocalName()) {
            case "entityType": {
                object.setEntityType((CrowdDeletedEntity.EntityType)inputCursor.getElemEnumValue(CrowdDeletedEntity.EntityType.class));
                break;
            }
            case "entityName": {
                object.setEntityName(inputCursor.getElemStringValue());
                break;
            }
            case "deletionDate": {
                object.setDeletionDate((Date)Preconditions.checkNotNull((Object)MapperUtil.parseDateElement(inputCursor)));
                break;
            }
            default: {
                log.warn((Object)("Unknown element to import: " + elementLocalName));
            }
        }
    }

    @Override
    public void afterImportListItem(@NotNull SMInputCursor cursor, @NotNull List<CrowdDeletedEntity> list, @NotNull CrowdDeletedEntity object, long objectIndex, @NotNull Session session) throws Exception {
        super.afterImportListItem(cursor, list, object, objectIndex, session);
        this.saveBambooObject(session, (BambooIdProvider)object);
    }
}

